<?php

use wdigital\cms\siteTree\widgets\SiteTreeWidget;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('site-tree', 'Edit section: ') . $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('site-tree', 'Site Tree'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a class="btn btn-primary btn-xs" href="<?= Url::to(['add'])?>">
                        <?=  Yii::t('site-tree', 'New section'); ?>
                    </a>
                </div>
            </div>
            <div class="ibox-content animated fadeInUp">
                <?= SiteTreeWidget::widget(['queryUrl' => Url::to([Yii::$app->getModule('site-tree')->ajaxDataUrl])]); ?>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('site-tree', 'By submitting this form you are editing a section.') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'edit-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['edit', 'id' => $model->id],
                            ])
                    ?>
                    <?= $form->field($model, 'parent_id')->dropDownList($parents,
                        ['prompt' =>
                            [ 'text' => Yii::t('site-tree', 'None'),'options' => ['value' => 0]]
                        ])
                    ?>
                    <?= $form->field($model, 'type')->dropDownList($dropDownList); ?>
                    <?= $form->field($model, 'title')->textInput(["data-slug-field" => "edit-name",'class'=>'form-control js-slug-field']) ?>
                    <?= $form->field($model, 'slug')->textInput(["data-slug-target" => "edit-name"]) ?>
                    <?= $form->field($model, 'meta_title')->textInput(['class' => 'form-control', 'maxlength' => true]) ?>
                    <?= $form->field($model, 'meta_description')->textInput(['class' => 'form-control', 'maxlength' => true]) ?>
                    <?= $form->field($model, 'active')->checkbox(['class' => 'js-switch']) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('site-tree', 'Save'), ['class' => 'btn btn-primary', 'name' => 'edit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
