<?php

use wdigital\cms\siteTree\widgets\SiteTreeWidget;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('site-tree', 'Edit section: '). ' ' . $model->title;
$this->params['breadcrumbs'][] = ['label' => Yii::t('site-tree', 'Site Tree'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a class="btn btn-primary btn-xs" href="<?= Url::to(['add']) ?>">
                        <?= Yii::t('site-tree', 'New section'); ?>
                    </a>
                </div>
            </div>
            <div class="ibox-content animated fadeInUp">
                <div hidden class="js-active-node-id" data-id="<?= $model->id ?>"></div>
                <div id="jstree1">
                    <?= SiteTreeWidget::widget(['siteTree' => $sections]); ?>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('site-tree', 'By submitting this form you are editing a section.') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                        'id' => 'edit-form',
                        'enableClientValidation' => false,
                        'options' => ['role' => 'form', 'method' => 'POST'],
                        'action' => ['edit', 'id' => $model->id],
                    ])
                    ?>
                    <?= $form->field($model, 'parent_id')->dropDownList($parents,
                        ['prompt' =>
                            ['text' => Yii::t('site-tree', 'None'), 'options' => ['value' => 0]]
                        ]
                    ) ?>
                    <?= $form->field($model, 'type')->dropDownList($dropDownList); ?>
                    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> >
                                <a
                                        href="#new-<?= $language['code'] ?>"
                                        data-toggle="tab"><?= Html::encode($language['name']); ?></a></li>
                        <?php endforeach; ?>
                    </ul>


                    <div class="tab-content">
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>"
                                 id="new-<?= $language['code'] ?>">

                                <?php $translatedModel = $model->getVariationModel($language['id']); ?>

                                <?= $form->field($translatedModel, "[{$language["id"]}]title")->textInput(['class' => 'form-control js-slug-field', "data-slug-field" => "new-name-{$language['id']}"]) ?>

                                <?= $form->field($translatedModel, "[{$language["id"]}]slug")->textInput(['data-slug-target' => "new-name-{$language['id']}"]) ?>

                                <?= $form->field($translatedModel, "[{$language["id"]}]meta_title")->textInput(['class' => 'form-control', 'maxlength' => 255]); ?>

                                <?= $form->field($translatedModel, "[{$language["id"]}]meta_description")->textInput(['class' => 'form-control', 'maxlength' => 255]); ?>

                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?= $form->field($model, 'active')->checkbox(['class' => 'js-switch']) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('site-tree', 'Save'), ['class' => 'btn btn-primary', 'name' => 'edit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
