<?php

namespace wdigital\cms\siteTree\components;

use yii\base\InvalidConfigException;

class ContentTypeClassResolver
{
    /**
     * @param string $type
     * @return mixed
     * @throws InvalidConfigException
     */
    public function getContentTypeClassInstance(string $type)
    {
        $contentTypes = \Yii::$app->getModule('site-tree')->content_types;
        foreach ($contentTypes as $contentType) {
            if (!empty($contentType['value']) && $contentType['value'] === $type && !empty($contentType['class'])) {
                return new $contentType['class'];
            }
        }
        throw new InvalidConfigException("Could not find content type {$type} class, please check your configuration!");
    }

}