function addActionToTreeObject(action, elemId, lang) {
    switch (action) {
        case 'edit':
            $('#' + elemId).jstree().add_action('all', {
                'id': 'action_edit',
                'class': 'fa fa-wrench fa-fw',
                'title': 'Edit node',
                'text': '',
                'after': 'true',
                'selector': 'a',
                'event': 'click',
                'callback': function (node_id, node, action_id, action_el) {
                    window.location = "/" + lang + "/site-tree/default/edit?id=" + node.id;
                }
            });
            break;
        case 'delete':
            $('#' + elemId).jstree().add_action('all', {
                'id': 'action_remove',
                'class': 'fa fa-trash fa-fw',
                'title': 'Remove node',
                'text': '',
                'after': 'true',
                'selector': 'a',
                'event': 'click',
                'callback': function (node_id, node, action_id, action_el) {
                    swal({
                        title: 'Lapas dzēsana',
                        text: 'Vai esat pārliecināti, ka vēlaties dzēst ' + node.text + ' sadaļu un tās apakšsadaļas?',
                        type: "warning",
                        showCancelButton: true,
                    }, function () {
                        $.ajax(
                            {
                                url: '/' + lang + '/site-tree/default/delete?id=' + node.id,
                                type: 'POST',
                                dataType: "json",
                                data: {
                                    node_id: node.id,
                                },
                                success: function (data) {
                                    toastr['success']("Sadaļa dzēsta", "Veiksmīgi!");
                                },
                                error: function (data) {
                                    toastr['error']("Sadaļa nav dzēsta", "neveiksmīgi!");
                                }
                            }
                        )
                    });
                }
            });
            break;
        case 'copyLink':
            $('#' + elemId).jstree().add_action('all', {
                'id': 'action_copy',
                'class': 'fa fa-clipboard fa-fw',
                'title': 'Copy URL',
                'text': '',
                'after': 'true',
                'selector': 'a',
                'event': 'click',
                'callback': function (node_id, node, action_id, action_el) {
                    var full_slug = node.data.s;
                    while (node.parent != '#') {
                        node = $('#' + elemId).jstree("get_node", node.parent);
                        full_slug = node.data.s + '/' + full_slug;
                    }
                    var el = document.createElement('textarea');
                    el.value = '/' + lang + '/' + full_slug;
                    document.body.appendChild(el);
                    el.select();
                    document.execCommand('copy');
                    document.body.removeChild(el);
                    toastr['success']("Saite nokopēta.", "Uzmanību!");
                }
            });
            break;
        case 'addChild':
            $('#' + elemId).jstree().add_action('all', {
                'id': 'action_add_child',
                'class': 'fa fa-plus fa-fw',
                'title': 'Add child node',
                'text': '',
                'after': 'true',
                'selector': 'a',
                'event': 'click',
                'callback': function (node_id, node, action_id, action_el) {
                    window.location = "/" + lang + "/site-tree/default/add?parent_id=" + node.id;
                }
            });
            break;
    }
}

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}

function createSiteTreeObjectConfig(id, queryUrl, enabledButtons) {

    $.jstree.plugins.actions = function (options, parent) {

        this._actions = {};

        this.add_action = function (node_id, action) {
            var self = this;
            var node_ids = typeof node_id === 'object' ? node_id : [node_id];

            var should_redraw_all = node_ids.indexOf("all") > -1;
            for (var i = 0; i < node_ids.length; i++) {
                var _node_id = node_ids[i];
                var actions = self._actions[_node_id] = self._actions[_node_id] || [];

                if (!self._has_action(_node_id, action.id)) {
                    actions.push(action);
                    if (!should_redraw_all) this.redraw_node(_node_id);
                }
            }

            if (should_redraw_all) this.redraw(true);
        };

        this.remove_action = function (node_id, action_id) {
            var self = this;
            var node_ids = typeof node_id === 'object' ? node_id :
                node_id === "all" ? Object.keys(this._actions) : [node_id];

            var should_redraw_all = node_ids.indexOf("all") > -1;
            for (var i = 0; i < node_ids.length; i++) {
                node_id = node_ids[i];
                var actions = self._actions[node_id] || [];
                var new_actions = [];

                for (var j = 0; j < actions.length; j++) {
                    var action = actions[j];
                    if (action.id !== action_id && action_id !== "all") {
                        new_actions.push(action);
                    }
                }

                var ids = actions.map(function (x) {
                    return x.id;
                });
                var new_ids = new_actions.map(function (x) {
                    return x.id;
                });

                if (ids.length != new_ids.length || ids.filter(function (n) {
                    return new_ids.indexOf(n) === -1;
                }).length) {
                    self._actions[node_id] = new_actions;

                    if (!should_redraw_all) this.redraw_node(node_id);
                }
            }

            if (should_redraw_all) {
                this.redraw(true);
            }
        };

        this._create_action = function (node_id, action_id) {
            var self = this;
            var action = this._get_action(node_id, action_id);
            if (action === null) return null;

            var action_el = document.createElement("i");
            action_el.className = action.class;
            action_el.textContent = action.text;
            if (action.title && action.title.length > 0) {
                action_el.title = action.title;
            }

            action_el.onclick = function (e) {
                var node = self.get_node(action_el);
                action.callback(node_id, node, action_id, action_el, e);
            };

            return {
                "action": action,
                "action_el": action_el
            };
        };

        this._get_action = function (node_id, action_id) {
            var actions = this._actions[node_id] || [];
            var v = null;
            for (var i = 0; i < actions.length; i++) {
                var action = actions[i];
                if (action.id === action_id) {
                    //TODO: fill empty fields with default values?
                    v = action;
                }
            }
            return v;
        };

        this._set_action = function (node_id, obj, action) {
            if (action === null) return;

            var place = obj.querySelector(action.action.selector);
            if (action.action.after) {
                place.parentNode.insertBefore(action.action_el, place.nextSibling);
            } else {
                obj.insertBefore(action.action_el, place);
            }
        };

        this._has_action = function (node_id, action_id) {
            var found = false;
            var actions = this._actions;

            if (actions.hasOwnProperty(node_id)) {
                for (var i = 0; i < actions[node_id].length; i++) {
                    if (actions[node_id][i].id === action_id) found = true;
                }
            }

            if (this._actions.hasOwnProperty('all')) {
                for (i = 0; i < actions['all'].length; i++) {
                    if (actions['all'][i].id === action_id) found = true;
                }
            }

            return found;
        };

        this.redraw_node = function (obj, deep, callback, force_draw) {
            var self = this;
            var node_id = typeof obj === "object" ? obj.id : obj;
            var el = parent.redraw_node.call(this, obj, deep, callback, force_draw);
            if (el) {
                //Check if we have any specific actions for this node
                var actions = this._actions[node_id] || [];

                for (var i = 0; i < actions.length; i++) {
                    var _action = self._create_action(node_id, actions[i].id);
                    self._set_action(node_id, el, _action);
                }

                actions = this._actions["all"] || [];

                for (i = 0; i < actions.length; i++) {
                    _action = self._create_action("all", actions[i].id);
                    self._set_action(node_id, el, _action);
                }
            }
            return el;
        };
    };

    var lang = $('html').attr('lang');
    var tree = $('#' + id).jstree({
        'core': {
            'data': {
                url: queryUrl
            },
            "check_callback": true,
            "themes": {
                "icons": false
            }
        },
        "plugins": ["dnd", "actions"],
        'types': {
            'default': {
                'icon': false
            }
        }
    });

    enabledButtons = JSON.parse(enabledButtons);
    Object.keys(enabledButtons).forEach(function (key) {
        if ((enabledButtons[key]) === true) {
            addActionToTreeObject(key, id, lang);
        }
    });

    tree.bind('ready.jstree', function (e, data) {
        var open = getUrlParameter('id');
        tree.jstree("select_node", open);
        if (open) {
            while (open != '#') {
                tree.jstree("open_node", open);
                open = tree.jstree("get_parent", open);
            }
        }
        tree.bind('select_node.jstree', function (e, data) {
            var type;
            if (data.node.data.t === 'html') {
                type = 'site-tree/html';
            } else if (data.node.data.t === 'redirect') {
                type = 'site-tree/default/edit';
            } else {
                type = data.node.data.t;
            }
            window.location.href = '/' + lang + '/' + type + '?id=' + data.node.id;
        });
    });

    tree.bind("move_node.jstree", function (e, data) {
        $.ajax(
            {
                url: '/' + lang + '/site-tree/default/tree-order-change',
                type: 'POST',
                dataType: "json",
                data: {
                    node_id: data.node.id,
                    new_parent: data.parent,
                    position: data.position,
                    old_parent: data.old_parent,
                    old_position: data.old_position
                },
                success: function (data) {

                },
                error: function () {
                    toastr['success']("Sadaļa pārvietota", "Uzmanību!");
                }
            });
        return true;
    });
}