<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\siteTree\Module;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\Response;

class DefaultController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors(): array
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    /**
     * @return string
     */
    public function actionIndex(): string
    {
        $module = Module::getInstance();
        $siteTree = $module->sectionClass::buildSiteTree();
        if ($module->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/multiple/index', [
                'sections' => $siteTree,
            ]);
        }
        return $this->render('@wd-site-tree/views/section/single/index', [
            'sections' => $siteTree,
        ]);

    }

    /**
     * @return string|Response
     */
    public function actionAdd()
    {
        $module = Module::getInstance();
        $model = new $module->sectionClass();
        $dropDownList = [];
        if (Yii::$app->request->isPost &&
            $model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(Url::to(['index']));
        }
        if ($parent_id = Yii::$app->request->get('parent_id')) {
            if ($module->multipleSiteTree) {
                $parents = $module->sectionClass::find()->select('title')->where(['id' => $parent_id])->limit(1)->indexBy('id')->column();
            } else {
                $parents = $module->sectionClass::find()->innerJoinWith('defaultTranslation')->select('title')->where(['id' => $parent_id])->limit(1)->indexBy('id')->column();
            }
            $model->parent_id = $parent_id;
        } else {
            $parents = [];
        }
        if($module->content_types) {
            foreach ($module->content_types as $contentType) {
                $dropDownList[$contentType['value']] = Yii::t($contentType['category'], $contentType['label']);
            }
        }
        if ($module->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/multiple/create', [
                'parents' => $parents,
                'model' => $model,
                'dropDownList' => $dropDownList
            ]);
        }
        return $this->render('@wd-site-tree/views/section/single/create', [
            'parents' => $parents,
            'model' => $model,
            'dropDownList' => $dropDownList
        ]);
    }

    /**
     * @param $id
     * @return string|Response
     * @throws NotFoundHttpException
     */
    public function actionEdit($id)
    {
        $module = Module::getInstance();
        $model = $module->sectionClass::find()->where(['id' => $id])->limit(1)->one();
        $dropDownList = [];
        if ($model) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(Url::to(['default/edit', 'id' => $model->id]));
            }
            if ($model->parent_id) {
                if ($module->multipleSiteTree) {
                    $parents = $module->sectionClass::find()->select('title')->where(['id' => $model->parent_id])->limit(1)->indexBy('id')->column();
                } else {
                    $parents = $module->sectionClass::find()->innerJoinWith('defaultTranslation')->select('title')->where(['id' => $model->parent_id])->limit(1)->indexBy('id')->column();
                }
            } else {
                $parents = [];
            }
            if($module->content_types) {
                foreach ($module->content_types as $contentType) {
                    $dropDownList[$contentType['value']] = Yii::t($contentType['category'], $contentType['label']);
                }
            }
            $siteTree = $module->sectionClass::buildSiteTree();
            if ($module->multipleSiteTree) {
                return $this->render('@wd-site-tree/views/section/multiple/edit', [
                    'sections' => $siteTree,
                    'model' => $model,
                    'parents' => $parents,
                    'dropDownList' => $dropDownList
                ]);
            }
            return $this->render('@wd-site-tree/views/section/single/edit', [
                'sections' => $siteTree,
                'model' => $model,
                'parents' => $parents,
                'dropDownList' => $dropDownList
            ]);
        }
        throw new NotFoundHttpException();
    }

    /**
     *
     */
    public function actionTreeOrderChange(): void
    {
        $post = Yii::$app->request->post();
        $module = Module::getInstance();
        $section = new $module->sectionClass();
        $foundSection = $section->find()->where(['id' => $post['node_id']])->one();
        $section->changeOrder($foundSection, $post);
    }

    /**
     * @param $id
     * @return Response
     * @throws NotFoundHttpException
     */
    public function actionDelete($id): Response
    {
        $module = Module::getInstance();
        if ($model = $module->sectionClass::find()->where(['id' => $id])->limit(1)->one()) {
            $model->delete();
            return $this->redirect(Url::to(['index']));
        }
        throw new NotFoundHttpException();
    }


}
