<?php
namespace wdigital\cms\siteTree\widgets;

use Yii;
use yii\base\Widget;
use yii\helpers\Html;
use yii\helpers\Url;

/**
 * Class Menu
 * Theme menu widget.
 */
class SiteTreeWidget extends Widget
{
    public $siteTree;
    public $activeNode;
    /**
     * {@inheritdoc}
     */
    public function init()
    {
        parent::init();
        if ($this->siteTree === null) {
            $this->siteTree = [];
        }
    }


    /**
     * {@inheritdoc}
     */
    public function run()
    {
        return $this->renderTree($this->siteTree);
    }

    /**
     * @inheritdoc
     */
    public function renderTree(array $nodeList): string
    {

        return Html::ul($nodeList, ['item' => function ($node) {
            $id = $node['id'];
            $class = $node['active'] ? 'noClass' : 'text-muted';
            $url = $this->getNodeUrl($node);
            $parent = $node['parent_id'];
            $nodeTextualDiv = $this->generateNodeTextualDiv($node);
            $childrenHtml = !empty($node['children']) ? $this->renderTree($node['children']) :  '';
            $nodeControlDiv = $this->generateNodeControlDiv($node);
            return "<li id={$id} class={$class} data-href={$url} data-parent={$parent}> {$nodeTextualDiv} {$childrenHtml} {$nodeControlDiv} </li>";
        }]);
    }

    /**
     * @param array $node
     * @return string
     */
    protected function generateNodeControlDiv(array $node): string
    {
        $title = Yii::t('site-tree', 'Section settings');
        $addTitle= Yii::t('site-tree', 'Add child section');
        $dataTitle = Yii::t('site-tree', 'Are you sure you?');
        $dataText = Yii::t('site-tree', 'Are you sure you want to delete section ').
            Html::encode($node['title']).
            Yii::t('site-tree', ' and it\'s children? ');
        $addUrl = Url::to(['add', 'parent_id'=>$node['id']]);
        $editUrl = Url::to(['edit', 'id'=>$node['id']]);
        $deleteUrl = Url::to(['delete', 'id'=>$node['id']]);
        $nodeSlug = $node['fullSlug'];
        $editAnchorTag = Html::a('<i class="fa fa-wrench fa-fw"></i>', $editUrl, [
            'class' => 'redirect inline-block js-tooltip-button',
            'data-placement' => 'top',
            'title' => $title]);
        $reorderAnchorTag = Html::a('<i class="fa fa-arrows fa-fw"></i>', '#', [
            'class' => 'dragHandle ui-sortable-handle js-tooltip-button',
            'data-placement' => 'top',
            'title' => '']);
        $deleteAnchorTag = Html::a('<i class="fa fa-trash fa-fw"></i>', $deleteUrl, [
            'class' => 'js-delete-button js-tooltip-button',
            'data-title' => $dataTitle,
            'data-text' => $dataText,
            'data-cancel' => 'Cancel',
            'data-ok' => 'Ok',
            'data-placement' => 'top']);
        $copySlugTag = Html::a('<i class="fa fa-clipboard fa-fw"></i>', '#', [
            'class' => 'js-clipboard',
            'data-clipboard-text' => $nodeSlug,
            'data-text' => $dataText,
            'data-placement' => 'top',
            'title' => '']);
        $addAnchorTag = Html::a('<i class="fa fa-plus fa-fw"></i>', $addUrl, [
            'class' => 'redirect inline-block js-tooltip-button',
            'data-placement' => 'top',
            'title' => $addTitle]);
        return "<div class=\"controls pull-right\" style=\"padding-right:15px;\">{$editAnchorTag}{$reorderAnchorTag}{$deleteAnchorTag}{$copySlugTag}{$addAnchorTag}</div>";
    }

    /**
     * @param array $node
     * @return string
     */
    protected function generateNodeTextualDiv(array $node): string
    {
        $isNodeActive = $node['active'] ? 'color:#1ab394' : '';
        $title = $node['title'];
        return "<div class='site-tree-list-element pull-left' style='padding-left:5px;{$isNodeActive}'>{$title}</div>";
    }
    /**
     * @param array $node
     * @return string
     */
    protected function getNodeUrl(array $node): string
    {
        if ($node['type'] === 'html') {
            return Url::to(['/site-tree/html/index', 'id' => $node['id']]);
        }
        return Url::to(['/' . $node['type'] . '/index', 'id' => $node['id']]);
    }
}
