<?php

namespace wdigital\cms\siteTree\migrations\multiple;

use yii\db\Migration;

/**
 * Handles the creation of table `vacancy`.
 */
class m171116_215030_create_setting_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('setting', [
            'id' => $this->primaryKey()->unsigned(),
            'key' => $this->string()->notNull(),
        ], $tableOptions);

        $this->createTable('setting_translation', [
            'setting_id' => $this->integer()->unsigned(),
            'language_id' => $this->integer()->unsigned(),
            'value' => $this->text(),
        ], $tableOptions);

        $this->addPrimaryKey(
            'pk_setting_translation',
            'setting_translation',
            ['setting_id', 'language_id']
        );

        $this->createIndex(
            'idx_setting_key',
            'setting',
            'key'
        );

        $this->createIndex(
            'idx_translation_setting',
            'setting_translation',
            'setting_id'
        );
        $this->createIndex(
            'idx_setting_translation_language',
            'setting_translation',
            'language_id'
        );
        $this->addForeignKey(
            'fk_translation_setting_setting',
            'setting_translation',
            'setting_id',
            'setting',
            'id',
            'CASCADE'
        );
        $this->addForeignKey(
            'fk_setting_translation_language',
            'setting_translation',
            'language_id',
            'language',
            'id',
            'CASCADE'
        );

    }

    /**
     * @inheritdoc
     */
    public function down()
    {
    }
}
