$(document).ready(function(){
    var clipboard = new Clipboard('.js-clipboard');
    var tree = $('#jstree1');
    var id = $('.js-active-node-id').attr('data-id');
    var lang = $('html').attr('lang');


    tree.bind('ready.jstree', function(e, data) {
        // invoked after jstree has loaded
        tree.jstree("close_all");
        tree.jstree("select_node", $("li#" + id));
    });
    tree.bind("move_node.jstree", function (e, data) {

        $.ajax(
            {
                url : '/'+lang+'/site-tree/default/tree-order-change',
                type: 'POST',
                dataType: "json",
                data : {node_id :  data.node.id, new_parent :  data.parent, position :  data.position, old_parent :  data.old_parent, old_position: data.old_position},
                error:function(){
                    toastr['success']("Sadaļa pārvietota", "Uzmanību!");
                }

            });
    });
    tree.jstree({
        'core' : {
            'check_callback' : true,
            'select_node' : false,
        },
        'plugins' : [ 'types', 'dnd' ],
        'types' : {
            'default' : {
                'icon' : false,
            },
        }
    });
    tree.bind('ready.jstree', function(e,data) {
        tree.bind('select_node.jstree', function(e,data) {
            window.location.href = data.node.data.href;
        });
    });
    tree.on('click', '.jstree-anchor > div > a', function (e) {
        if($(this).hasClass('js-delete-button')) {
            e.stopPropagation();
            e.preventDefault();
            var linkURL = $(this);
            warnBeforeRedirect(linkURL);
        }
        if($(this).hasClass('js-clipboard')){
            var clipboard = new Clipboard();
            clipboard.on('success', function(e) {
                e.preventDefault();
                toastr['success']("Saite uz sadaļu ir nokopēta!", "Uzmanību!");
                toastr.clear();
            });
            clipboard.on('error', function(e) {
                e.preventDefault();
            });
            e.preventDefault();
        }
        if($(this).hasClass('redirect')){
            e.stopPropagation();
            e.preventDefault();
            window.location.href = $(this).attr('href');
        }
        //$('#jstree1').jstree(true).delete_node(this);
    });



});