<?php

namespace wdigital\cms\siteTree;


use wdigital\cms\siteTree\models\MultipleTreeSection;
use wdigital\cms\siteTree\models\SingleTreeSection;
use yii\base\Module as BaseModule;

class Module extends BaseModule
{
    public $content_types;
    public $multipleSiteTree;
    public $sectionClass;
    public function __construct($id, $parent = null, array $config = [])
    {
        if (empty($config['content_types'])) {
            $config['content_types'] =
                [
                    ['value' => 'html', 'label' => 'HTML section', 'category' => 'site-tree', 'class' => models\Html::class],
                    ['value' => 'redirect', 'label' => 'Redirect section', 'category' => 'site-tree'],
                    ['value' => 'gdpr', 'label' => 'GDPR section', 'category' => 'site-tree']
                ];
        }
        if (!isset($config['multipleSiteTree'])) {
            $config['multipleSiteTree'] = true;
            $config['content_types'] =
                [
                    ['value' => 'html', 'label' => 'HTML section', 'category' => 'site-tree', 'class' => models\Html::class],
                    ['value' => 'redirect', 'label' => 'Redirect section', 'category' => 'site-tree'],
                    ['value' => 'gdpr', 'label' => 'GDPR section', 'category' => 'site-tree']
                ];
        }
        if (!isset($config['sectionClass'])) {
            if ($config['multipleSiteTree']) {
                $config['sectionClass'] = MultipleTreeSection::class;
            } else {
                $config['sectionClass'] = SingleTreeSection::class;
            }
        }
        parent::__construct($id, $parent, $config);
    }
}
