<?php

namespace wdigital\cms\siteTree\widgets;

use yii\helpers\ArrayHelper;
use iutbay\yii2kcfinder\KCFinderAsset;
use dosamigos\ckeditor\CKEditor as BaseCKEditor;

class CKEditor extends BaseCKEditor
{
    public $enableKCFinder = true;

    /**
     * Registers CKEditor plugin
     */
    protected function registerPlugin(): void
    {
        if ($this->enableKCFinder)
        {
            $this->registerKCFinder();
        }

        parent::registerPlugin();
    }

    /**
     * Registers KCFinder
     */
    protected function registerKCFinder(): void
    {
        $register = KCFinderAsset::register($this->view);
        $kcfinderUrl = $register->baseUrl;

        $browseOptions = [
            'filebrowserBrowseUrl' => $kcfinderUrl . '/browse.php?opener=ckeditor&type=files',
            'filebrowserUploadUrl' => $kcfinderUrl . '/upload.php?opener=ckeditor&type=files',
            'height' => 300,
            'toolbarGroups' => [
                ['name' => 'clipboard', 'groups' => ['mode', 'undo', 'selection', 'clipboard', 'doctools']],
                ['name' => 'editing', 'groups' => ['tools', 'about']],
                '/',
                ['name' => 'paragraph', 'groups' => ['templates', 'list', 'indent', 'align']],
                ['name' => 'insert'],
                '/',
                ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                ['name' => 'colors'],
                ['name' => 'links'],
                ['name' => 'others'],
                ['name' => 'styles', 'groups' => ['styles']],
            ],
            'removeButtons' => 'Styles,Font,FontSize'
        ];

        $this->clientOptions = ArrayHelper::merge($this->clientOptions, $browseOptions);
    }
}