<?php

namespace wdigital\cms\siteTree\models;


use Yii;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "html".
 *
 * @property int $id
 * @property int $section_id
 * @property string $content
 *
 * @property MultipleTreeSection $section
 */

class Html extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName(): string
{
    return 'html';
}

    /**
     * {@inheritdoc}
     */
    public function rules(): array
{
    return [
        [['section_id'], 'required'],
        [['section_id'], 'integer'],
        [['content'], 'string'],
        [['section_id'], 'exist', 'skipOnError' => true, 'targetClass' => MultipleTreeSection::class, 'targetAttribute' => ['section_id' => 'id']],
    ];
}

    /**
     * {@inheritdoc}
     */
    public function attributeLabels(): array
{
    return [
        'id' => Yii::t('site-tree', 'ID'),
        'section_id' => Yii::t('site-tree', 'Section ID'),
        'content' => Yii::t('site-tree', 'Content'),
    ];
}

    /**
     * @return ActiveQuery
     */
    public function getSection(): ActiveQuery
    {
    return $this->hasOne(MultipleTreeSection::class, ['id' => 'section_id']);
}
}