<?php

namespace wdigital\cms\siteTree\migrations\single;

use yii\db\Migration;

/**
 * Handles the creation of table `html`.
 */
class m171114_135056_create_html_content_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('html', [
            'id' => $this->primaryKey()->unsigned(),
            'section_id' => $this->integer()->notNull()->unsigned(),
        ], $tableOptions);
        $this->createIndex(
            'idx_html_section_id', 'html', 'section_id'
        );
        $this->addForeignKey(
            'fk_html_section_id', 'html', 'section_id', 'section', 'id', 'CASCADE'
        );

        $this->createTable('html_translation', [
            'html_id' => $this->integer()->unsigned(),
            'language_id' => $this->integer()->unsigned(),
            'content' => $this->text(),
        ], $tableOptions);

        $this->addPrimaryKey('pk_html_translation', 'html_translation', ['html_id', 'language_id']);
        $this->createIndex(
            'idx_html_translation_html', 'html_translation', 'html_id'
        );
        $this->addForeignKey(
            'fk_html_translation_html', 'html_translation', 'html_id', 'html', 'id', 'CASCADE'
        );
        $this->createIndex(
            'idx_html_translation_language', 'html_translation', 'language_id'
        );
        $this->addForeignKey(
            'fk_html_translation_language', 'html_translation', 'language_id', 'language', 'id', 'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropForeignKey('fk_html_translation_language', 'html_translation');
        $this->dropForeignKey('fk_html_translation_section', 'html_translation');
        $this->dropTable('html_translation');

        $this->dropForeignKey('fk_html_section_id', 'html');
        $this->dropTable('html');
    }

}
