<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\siteTree\models\Html;
use wdigital\cms\siteTree\models\TranslatableHtml;
use wdigital\cms\siteTree\Module;
use Yii;
use yii\base\Model;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

class HtmlController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors(): array
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * @param int $section_id
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException
     */
    public function actionEdit(int $section_id)
    {
        $module = Module::getInstance();
        if (Yii::$app->request->isPost) {
            if ($module->multipleSiteTree) {
                $model = Html::find()->where(['section_id' => $section_id])->limit(1)->one();
            } else {
                $model = TranslatableHtml::find()->where(['section_id' => $section_id])->limit(1)->one();
            }
        } else if ($module->multipleSiteTree) {
            $model = Html::find()->where(['section_id' => $section_id])->limit(1)->one();
        } else {
            $model = TranslatableHtml::find()->where(['section_id' => $section_id])->limit(1)->one();
        }
        if ($model) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(Url::to(['default/index', 'id' => $section_id]));
            }
            if (!$module->multipleSiteTree) {
                return $this->render('@wd-site-tree/views/section/html/single/edit',
                    [
                        'model' => $model,
                    ]
                );
            }
            return $this->render('@wd-site-tree/views/section/html/multiple/edit',
                [
                    'model' => $model,
                ]
            );
        }
        throw new NotFoundHttpException();
    }
}
