<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\siteTree\Module;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\Response;

class DefaultController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors(): array
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    /**
     * @return string
     */
    public function actionIndex(): string
    {
        $module = Module::getInstance();
        if (!$module->multipleSiteTree) {
            $sectionsQuery = $module->sectionClass::find()
                ->joinWith('defaultTranslation');
        } else {
            $sectionsQuery = $module->sectionClass::find()
                ->where(['language_id' => Yii::$app->getModule('language')->languageClass::getIdFromCode(Yii::$app->language)]);
        }
        $sections = $sectionsQuery->orderBy('order_by ASC')->all();
        $module->sectionClass::generateSiteTreeStructure($sections);
        if (!$module->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/multiple/index', [
                'sections' => $sections,
            ]);
        }
        return $this->render('@wd-site-tree/views/section/single/index', [
            'sections' => $sections,
        ]);

    }

    /**
     * @return string|Response
     */
    public function actionAdd()
    {
        $module = Module::getInstance();
        $model = new $module->sectionClass();
        if (Yii::$app->request->isPost &&
            $model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(Url::to(['index']));
        }
        if (!$module->multipleSiteTree) {
            $sections = $module->sectionClass::find()->joinWith('defaultTranslation');
        } else {
            $sections = $module->sectionClass::find()
                ->where(['language_id' => Yii::$app->getModule('language')->languageClass::getIdFromCode(Yii::$app->language)]);
        }
        $sections = $sections->orderBy('order_by ASC')->all();
        $sectionTitles = [];
        foreach ($sections as $section) {
            $sectionTitles[$section->id] = $section->title;
        }
        if (!$module->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/single/create', [
                'sections' => $sectionTitles,
                'model' => $model
            ]);
        }
        return $this->render('@wd-site-tree/views/section/multiple/create', [
            'sections' => $sectionTitles,
            'model' => $model
        ]);
    }

    /**
     * @param $id
     * @return string|Response
     * @throws NotFoundHttpException
     */
    public function actionEdit($id)
    {
        $module = Module::getInstance();
        $model = $module->sectionClass::find()->where(['id' => $id])->limit(1)->one();
        if ($model) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(Url::to(['default/edit', 'id' => $model->id]));
            }
            if (!$module->multipleSiteTree) {
                $sections = $module->sectionClass::find()->joinWith('defaultTranslation');
            } else {
                $sections = $module->sectionClass::find()
                    ->where(['language_id' => Yii::$app->getModule('language')->languageClass::getIdFromCode(Yii::$app->language)]);
            }
            $sections = $sections->orderBy('order_by ASC')->all();
            $sectionTitles = [];
            foreach ($sections as $section) {
                $sectionTitles[$section->id] = $section->title;
            }
            $module->sectionClass::generateSiteTreeStructure($sections);

            if (!$module->multipleSiteTree) {
                return $this->render('@wd-site-tree/views/section/single/edit', [
                    'sections' => $sections,
                    'model' => $model,
                    'parents' => $sectionTitles
                ]);
            }
            return $this->render('@wd-site-tree/views/section/multiple/edit', [
                'sections' => $sections,
                'model' => $model,
                'parents' => $sectionTitles
            ]);
        }
        throw new NotFoundHttpException();
    }

    /**
     *
     */
    public function actionTreeOrderChange(): void
    {
        $post = Yii::$app->request->post();
        $module = Module::getInstance();
        $section = new $module->sectionClass();
        $foundSection = $section->find()->where(['id' => $post['node_id']])->one();
        $section->changeOrder($foundSection, $post);
    }

    /**
     * @param $id
     * @return Response
     * @throws NotFoundHttpException
     */
    public function actionDelete($id): Response
    {
        $module = Module::getInstance();
        if ($model = $module->sectionClass::find()->where(['id' => $id])->limit(1)->one()) {
            $model->delete();
            return $this->redirect(Url::to(['index']));
        }
        throw new NotFoundHttpException();
    }


}
