<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\siteTree\models\Html;
use wdigital\cms\siteTree\Module;
use Yii;
use yii\base\Model;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

class HtmlController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors(): array
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }
    /**
     * @param $id
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException
     */
    public function actionEdit($id)
    {
        $module = Module::getInstance();
        if (Yii::$app->request->isPost) {
            $model = Html::find()->where(['id' => $id])->limit(1)->one();
        } else {
            $model = Html::find()->where(['section_id' => $id])->limit(1)->one();
        }
        if ($model) {
            $post = Yii::$app->request->post();
            if ($model->load($post) || Yii::$app->request->isPost) {
                if (!$module->multipleSiteTree) {
                    $translationModels = ArrayHelper::map(
                        $model->getVariationModels(),
                        'language_id',
                        function ($translatedModel) {
                            return $translatedModel;
                        }
                    );
                    if (Model::loadMultiple($translationModels, $post) && $model->setVariationModels($translationModels) && $model->save()) {
                        return $this->redirect(Url::to(['default/index', 'id' => $id]));
                    }
                } else if ($model->save()) {
                    return $this->redirect(Url::to(['default/index', 'id' => $id]));
                }
            }
            if (!$module->multipleSiteTree) {
                return $this->render('@wd-site-tree/views/section/html/single/edit',
                    [
                        'model' => $model,
                    ]
                );
            }
            return $this->render('@wd-site-tree/views/section/html/multiple/edit',
                [
                    'model' => $model,
                ]
            );

        }
        throw new NotFoundHttpException();
    }
}
