<?php
namespace wdigital\cms\siteTree\widgets;

use wdigital\cms\siteTree\assets\SlickAsset;
use Yii;
use yii\base\Widget;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\helpers\Html;

/**
 * Class Menu
 * Theme menu widget.
 */
class SiteTree extends Widget
{
    /**
     * @inheritdoc
     */
    public function renderTree($children,$active_section_id, $expanded, $tree, $seperator = '') {
        $tree .= '<ul>';
        foreach($children as $child){
            $tree .= '<li id="'.$child->id.'"';
            if($child->active == 0){
                $tree .= ' class="text-muted"';
            }
            if($child->type == 'html'){
                $tree .= 'data-href="'.Url::to(['/site-tree/html/edit', 'id' => $child->id]).'"';
            }else if($child->type == 'redirect'){
                $tree .= 'data-href="'.Url::to(['/site-tree/default/edit?id='.$child->id]).'"';
            }else if($child->type == 'gdpr'){
                $tree .= 'data-href="'.Url::to(['/site-tree/gdpr/edit', 'id' => $child->id]).'"';
            }else {
                $tree .= 'data-href="'.Url::to(['/'.$child->type.'/index', 'id' => $child->id]).'"';
            }
            $tree .= 'data-parent="'.$child->parent_id.'"><span class="pull-left" style="padding-left:5px;';
            if($child->active == 1){
                $tree .= 'color:#1ab394';
            }
            $tree .='">'.$child->title.'</span>';
            if(!empty($child->children)){
                $site_tree = new self();
                $tree .= $site_tree->renderTree($child->children, '',$child->id,$active_section_id,$expanded,$tree,$child);
            }
            $tree .='<div class="controls pull-right" style="padding-right:15px;">';
            $tree .='<a class="redirect inline-block js-tooltip-button"';

            $tree .= 'title="'.Yii::t('site-tree', 'Section settings').'" data-placement="top"';
            $tree .= 'href="'.Url::to(['edit', 'id'=>$child->id]).'">';
            $tree .= '<i class="fa fa-wrench fa-fw"></i>';
            $tree .= '</a>';
            $tree .='<a href="/site-tree/'.$child->id.'"></a>';
            $tree .= '<a href="#" class="dragHandle ui-sortable-handle js-tooltip-button" title="" data-placement="top">';
            $tree .= '<i class="fa fa-arrows fa-fw"></i>';
            $tree .= '</a>';
            $tree .= '<a href="'.Url::to(['delete', 'id'=>$child->id]).'"';
            $tree .= 'class="js-delete-button js-tooltip-button"';
            $tree .= 'data-title="'.Yii::t('site-tree', 'Are you sure you?').'"';
            $tree .= 'data-placement="top"';
            $tree .= 'data-text="' .Yii::t('site-tree', 'Are you sure you want to delete section ').Html::encode($child->title).Yii::t('site-tree', ' and it\'s children? ').'">';
            $tree .= '<i class="fa fa-trash fa-fw"></i>';
            $tree .= '</a>';
            $tree .= '<a href"#" class="js-clipboard" data-clipboard-text="'.$child->fullSlug.'"';
            $tree .= 'data-placement="top">';
            $tree .= '<i class="fa fa-clipboard fa-fw"></i>';
            $tree .= '</a>';
            $tree .= '</div>';
            $tree .='</li>';
        }
        $tree .= '</ul>';
        return $tree;
    }

    public function renderTreePermissions($children,$active_section_id, $expanded, $tree, $seperator = '') {
        $tree .= '<ul>';
        foreach($children as $child){
            $tree .= '<li>';
            if($seperator != ''){
                $tree.= $seperator;
            }
            $tree.= $child->title;
            if(!empty($child->children)){
                $tree .= self::renderTree($child->children, '',$child->id,$active_section_id,$expanded,$tree,$child);
            }
            $tree .='</li>';
        }
        $tree .= '</ul>';
        return $tree;
    }
}
