<?php

use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('site-tree', 'Create a new section');
$this->params['breadcrumbs'][] = ['label' => Yii::t('site-tree', 'Site Tree'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('site-tree', 'By submitting this form you create a new section.') ?></small>
                </div>
                <div class="ibox-content">
                    <?php $form = ActiveForm::begin([
                        'enableClientValidation' => false,
                        'options' =>
                            [
                                'role' => 'form', 'method' => 'POST',
                            ],
                        'id' => 'create-form'
                    ]);
                    ?>
                    <?= $form->field($model, 'parent_id')->dropDownList($sections, ['prompt' => ['text' => Yii::t('site-tree', 'None'), 'options' => ['value' => 0]]]) ?>
                    <?php if (Yii::$app->getModule('site-tree')->content_types) {
                        $dropdownList = [];
                        foreach (Yii::$app->getModule('site-tree')->content_types as $contentType) {
                            $dropdownList[$contentType['value']] = Yii::t($contentType['category'], $contentType['label']);
                        }
                    } ?>
                    <?= $form->field($model, 'type')->dropDownList($dropdownList,
                        ['prompt' =>
                            [
                                'text' => Yii::t('site-tree', 'None'), 'options' => ['value' => 0]
                            ]
                        ]);
                    ?>

                    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> >
                                <a
                                        href="#new-<?= $language['code'] ?>"
                                        data-toggle="tab"><?= Html::encode($language['name']); ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                    <div class="tab-content">
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>"
                                 id="new-<?= $language['code'] ?>">

                                <?php $translatedModel = $model->getVariationModel($language['id']); ?>

                                <?= $form->field($translatedModel, "[{$language["id"]}]title")->textInput(['class' => 'form-control js-slug-field', "data-slug-field" => "new-name-{$language['id']}"]) ?>

                                <?= $form->field($translatedModel, "[{$language["id"]}]slug")->textInput(['data-slug-target' => "new-name-{$language['id']}"]) ?>

                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?= $form->field($model, 'active')->checkbox(['class' => 'js-switch']) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('site-tree', 'Save'), ['class' => 'btn btn-primary', 'name' => 'submit-button']) ?>
                    </div>
                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
