<?php

namespace wdigital\cms\siteTree\migrations\single;

use yii\db\Migration;

/**
 * Handles the creation of table `site_tree`.
 */
class m171114_124604_create_site_tree_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        //SECTIONS
        $this->createTable('section', [
            'id' => $this->primaryKey()->unsigned(),
            'parent_id' => $this->integer(11)->defaultValue(null)->unsigned(),
            'type' => $this->string()->notNull(),
            'active' => $this->boolean()->notNull()->defaultValue(0),
            'order_by' => $this->integer()->notNull(),
            'image' => $this->string()
        ], $tableOptions);
        $this->createIndex('idx_section_parent_id', 'section', 'parent_id');
        $this->addForeignKey('fk_section_parent_id', 'section', 'parent_id', 'section', 'id', 'CASCADE');

        $this->createTable('section_translation', [
            'section_id' => $this->integer()->unsigned(),
            'language_id' => $this->integer()->unsigned(),
            'title' => $this->string(),
            'slug' => $this->string(),
            'redirect_to' => $this->string(),
        ], $tableOptions);

        $this->addPrimaryKey('pk_section_translation', 'section_translation', ['section_id', 'language_id']);
        $this->createIndex(
            'idx_section_translation_section', 'section_translation', 'section_id'
        );
        $this->addForeignKey(
            'fk_section_translation_section', 'section_translation', 'section_id', 'section', 'id', 'CASCADE'
        );
        $this->createIndex(
            'idx_section_translation_language', 'section_translation', 'language_id'
        );
        $this->addForeignKey(
            'fk_section_translation_language', 'section_translation', 'language_id', 'language', 'id', 'CASCADE'
        );

        $this->createIndex(
            'idx_section_active', 'section', 'active'
        );

        $this->createIndex(
            'idx_section_translation_slug', 'section_translation', 'slug'
        );

        $this->createIndex(
            'idx_section_type', 'section', 'type'
        );

        $this->createIndex(
            'idx_section_order_by', 'section', 'order_by'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropForeignKey('fk_section_translation_language', 'section_translation');
        $this->dropForeignKey('fk_section_translation_section', 'section_translation');
        $this->dropTable('section_translation');

        $this->dropForeignKey('fk_section_parent_id', 'section');
        $this->dropTable('section');
    }
}
