<?php

namespace wdigital\cms\siteTree\migrations\multiple;

use yii\db\Migration;

/**
 * Handles the creation of table `vacancy`.
 */
class m171116_215030_create_settings_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('settings', [
            'id' => $this->primaryKey()->unsigned(),
            'key' => $this->string()->notNull(),
            'value' => $this->text(),
        ], $tableOptions);
        $this->createTable('settings_translation', [
            'settings_id' => $this->integer()->unsigned(),
            'language_id' => $this->integer()->unsigned(),
            'value' => $this->text(),
        ], $tableOptions);
        $this->addPrimaryKey("pk_settings_translation", "settings_translation", ['settings_id', 'language_id']);
        $this->createIndex(
            'idx_translation_settings', 'settings_translation', 'settings_id'
        );
        $this->createIndex(
            'idx_settings_translation_language', 'settings_translation', 'language_id'
        );
        $this->addForeignKey(
            'fk_translation_settings', 'settings_translation', 'settings_id', 'settings',
            'id', 'CASCADE'
        );
        $this->addForeignKey(
            'fk_settings_translation_language', 'settings_translation', 'language_id', 'language',
            'id', 'CASCADE'
        );

    }

    /**
     * @inheritdoc
     */
    public function down()
    {
    }
}
