<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\siteTree\models\Section;
use wdigital\cms\siteTree\Module;
use Yii;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;

class DefaultController extends Controller
{

    /**
     * @return string
     */
    public function actionIndex(): string
    {
        $module = Module::getInstance();
        if (!$module->multipleSiteTree) {
            $sectionsQuery = $module->sectionClass::find()->joinWith('defaultTranslation');
        } else {
            $sectionsQuery = $module->sectionClass::find()->where(['lang' => Yii::$app->language]);
        }
        $sections = $sectionsQuery->orderBy('order_by ASC')->all();
        $module->sectionClass::generateSiteTreeStructure($sections);
        return $this->render('@wd-site-tree/views/section/multiple/index', [
            'sections' => $sections,
        ]);
    }

    /**
     * @return string|\yii\web\Response
     */
    public function actionAdd()
    {
        $module = Module::getInstance();
        $model = new $module->sectionClass();
        if (Yii::$app->request->isPost &&
            $model->load(Yii::$app->request->post()) &&
            $model->createNew(Yii::$app->request->post())) {
            return $this->redirect(Url::to(['index']));
        }
        if (!$module->multipleSiteTree) {
            $sections = $module->sectionClass::find()->joinWith('defaultTranslation');
        } else {
            $sections = $module->sectionClass::find()->where(['lang' => Yii::$app->language]);
        }
        $sections = $sections->orderBy('order_by ASC')->all();
        $section_titles = [];
        foreach ($sections as $section) {
            $section_titles[$section->id] = $section->title;
        }
        if (!$module->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/single/create', [
                'sections' => $section_titles,
                'model' => $model
            ]);
        }
        return $this->render('@wd-site-tree/views/section/multiple/create', [
            'sections' => $section_titles,
            'model' => $model
        ]);
    }

    /**
     * @param $id
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException
     */
    public function actionEdit($id)
    {
        $module = Module::getInstance();
        $model = $module->sectionClass::find()->where(['id' => $id])->limit(1)->one();
        if ($model) {
            if (Yii::$app->request->isPost && $model->load(Yii::$app->request->post())) {
                if ($model->editSection(Yii::$app->request->post())) {
                    return $this->redirect(Url::to(['default/edit', 'id' => $model->id]));
                }
            }
            if (!$module->multipleSiteTree) {
                $sections = $module->sectionClass::find()->joinWith('defaultTranslation');
            } else {
                $sections = $module->sectionClass::find()->where(['lang' => Yii::$app->language]);
            }
            $sections = $sections->orderBy('order_by ASC')->all();
            $section_titles = [];
            foreach ($sections as $section) {
                $section_titles[$section->id] = $section->title;
            }
            $module->sectionClass::generateSiteTreeStructure($sections);

            if (!$module->multipleSiteTree) {
                return $this->render('@wd-site-tree/views/section/single/edit', [
                    'sections' => $sections,
                    'model' => $model,
                    'parents' => $section_titles
                ]);
            }
            return $this->render('@wd-site-tree/views/section/multiple/edit', [
                'sections' => $sections,
                'model' => $model,
                'parents' => $section_titles
            ]);
        }
        throw new NotFoundHttpException();
    }

    public function actionTreeOrderChange(): void
    {

        $post = Yii::$app->request->post();
        $section = new Section();
        $found_section = $section->find()->where(['id' => $post['node_id']])->one();
        $section->changeOrder($found_section, $post);
        //return json_encode(['success' => true ]);
    }

    /**
     * @param $id
     * @return \yii\web\Response
     * @throws NotFoundHttpException
     */
    public function actionDelete($id): \yii\web\Response
    {
        if ($model = \Yii::$app->getModule('site-tree')->sectionClass::find()->where(['id' => $id])->limit(1)->one()) {
            $model->delete();
            return $this->redirect(Url::to(['index']));
        }
        throw new NotFoundHttpException();
    }


}
