<?php

use wdigital\cms\siteTree\widgets\SiteTree;
use yii\base\DynamicModel;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('site-tree', 'Edit the HTML content') . $html->section->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('site-tree', 'Site Tree'), 'url' => ['default/index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('site-tree', 'By submitting this form you are updating the HTML content.') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'edit-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['', 'lang' => Yii::$app->language, 'id' => $html->id],
                            ])
                    ?>
                    <?= $form->field($html, 'content')->textarea(['class' => 'ckeditor']) ?>
                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('site-tree', 'Save'), ['class' => 'btn btn-primary', 'name' => 'edit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    CKEDITOR.replace( 'content', {
    customConfig: '/backend/js/plugins/ckeditor/config.js'
    } );
</script>
