<?php
namespace wdigital\cms\siteTree\models;

use wdigital\cms\i18n\components\translatableModel\TranslatableTrait;
use Yii;
use yii\db\ActiveRecord;
use yii\web\UploadedFile;

/**
 * @property int    $id
 * @property int    $parent_id
 * @property string $name
 * @property string $slug
 * @property string $type
 * @property bool   $active
 * @property int    $order_by
 * @property string $lang
 * @property string $redirect_to
 * @property string $image
 */
class Settings extends ActiveRecord {


    use TranslatableTrait{
        find as findWithTranslations;
    }
    public static function find()
    {
        return parent::find();
    }


    const SCENARIO_SAVE = 'save';
    const SCENARIO_UPDATE = 'update';

    public function attributeLabels() {
        return [
            'value' => '',
        ];
    }
    public function rules() {
        return [
            [['key', 'value'], 'safe'],
        ];
    }
    public function createNew($key, $value){
	    $model = new self();
	    $model->key = $key;
	    $model->value = $value;
        if($model->save()){
            return true;
        }else{
            return false;
        }
    }
    public function updateSetting($key, $value = 0, $post = 0, $model){
        $model->load($post);
	    if($value === 0) {
            $model->setAttributes($post, false);
        }
        if($model->save()){
            return true;
        }else{
            return false;
        }
    }
}
