<?php

namespace wdigital\cms\siteTree\models;

use common\components\FileControl;
use common\models\ContentTypes;
use common\models\ContentTypes\Contact;
use common\models\ContentTypes\SocialPost;
use Yii;
use yii\db\ActiveRecord;
use yii\web\NotFoundHttpException;

/**
 * @property int $id
 * @property int $parent_id
 * @property string $name
 * @property string $slug
 * @property string $type
 * @property bool $active
 * @property int $order_by
 * @property string $lang
 * @property string $redirect_to
 * @property string $image
 */
class Section extends ActiveRecord
{

    const TABLE = '{{%sections}}';
    const IMG_DIR = 'uploads/sections';
    public static $tree = null;
    public $children = [];
    public $depth;
    public $path;
    public $currSection = null;
    public $prevSection = null;
    public $articleSlug = null;
    public $fullSlug;

    public function getParent()
    {
        return $this->hasOne(self::className(), ['id' => 'parent_id'])->from(['parent' => self::tableName()]);
    }

    public function getHtml()
    {
        return $this->hasMany(Html_::className(), ['section_id' => 'id']);
    }

    public function getChilds()
    {
        return $this->hasMany(self::className(), ['parent_id' => 'id'])->from(['child' => self::tableName()])->where(['child.active' => 1]);
    }

    public function attributeLabels()
    {
        return [
            'parent_id' => Yii::t('site-tree', 'Parent section'),
            'type' => Yii::t('site-tree', 'Section type'),
            'name' => Yii::t('site-tree', 'Name'),
            'slug' => Yii::t('site-tree', 'Slug'),
        ];
    }

    public function rules()
    {
        return [
            [['parent_id', 'lang'], 'safe'],
            [['name', 'slug', 'type'], 'required'],
            ['image', 'file', 'extensions' => ['png', 'jpg', 'gif', 'jpeg']],
            ['image', 'image', 'minWidth' => 1920, 'minHeight' => 250],
        ];
    }

    /**
     * @param $post
     * @return bool
     */
    public function createNew($post)
    {
        $section = new self();
        $section->load($post);
        if ($section->parent_id == 0) {
            $section->parent_id = null;
        }
        $last_order = self::find()->orderBy('order_by DESC')->one();
        if ($last_order != null) {
            $section->order_by = $last_order->order_by + 1;
        } else {
            $section->order_by = 1;
        }
        if ($post['Section']['active'] == 1) {
            $section->active = 1;
        } else {
            $section->active = 0;
        }

        $section->lang = Yii::$app->language;
        if ($section->save()) {
            if ($section->type == 'html') {
                $html = new Html_();
                $html->scenario = Html_::SCENARIO_SAVE;
                $html->createNew($section->id, '');
            }
            if ($section->type == 'card') {
                $settings = new Settings();
                $key = 'card-text-' . $section->id;
                $value = '';
                $settings->createNew($key, $value);
            }
            return true;
        } else {
            ;
            return false;
        }
    }

    public function editsection($post, $id)
    {
        $section = new self();
        $section = $section::find()->where(['id' => $id])->one();
        $section->load($post);
        if ($section->parent_id == 0) {
            $section->parent_id = null;
        }
        if ($post['Section']['active'] == 1) {
            $section->active = 1;
        } else {
            $section->active = 0;
        }
        $section->lang = Yii::$app->language;
        if ($section->save()) {
            if ($section->type == 'html') {
                $html = new Html_();
                $html->scenario = Html_::SCENARIO_SAVE;
                $html->createNew($section->id, '');
            }
            return true;
        } else {
            return false;
        }
    }

    public function changeOrder($section, $post)
    {
        $model = new Section();
        $updated_section = $section;
        if ($post['new_parent'] == '#') {
            $updated_section->parent_id = null;
        } else {
            $updated_section->parent_id = $post['new_parent'];
        }
        if ($post['new_parent'] == '#') {
            $sections = $model->find()->where(['parent_id' => NULL])->andWhere(['lang' => Yii::$app->language])->orderBy('order_by asc')->all();
            if ($post['old_position'] > $post['position']) {
                foreach ($sections as $s) {
                    if ($s->id != $post['node_id']) {
                        if ($s->order_by >= $post['position']) {
                            $s->order_by += 1;
                            $s->save();
                        }
                    }
                }
            } else {
                $count = 0;
                foreach ($sections as $s) {
                    if ($s->id != $post['node_id']) {
                        if ($count + 1 <= $post['position']) {
                            $s->order_by = $count;
                            $s->save();
                        }
                        $count += 1;
                    }
                }
            }
            $updated_section->order_by = $post['position'];
        } else {
            $sections = $model->find()->where(['parent_id' => $post['new_parent']])->andWhere(['lang' => Yii::$app->language])->orderBy('order_by asc')->all();
            if ($post['old_position'] > $post['position']) {
                foreach ($sections as $s) {
                    if ($s->id != $post['node_id']) {
                        if ($s->order_by >= $post['position']) {
                            $s->order_by += 1;
                            $s->save();
                        }
                    }
                }
            } else {
                foreach ($sections as $s) {
                    if ($s->id != $post['node_id']) {
                        if ($s->order_by <= $post['position']) {
                            $s->order_by -= 1;
                            $s->save();
                        }
                    }
                }
            }
            $updated_section->order_by = $post['position'];
        }
        if ($updated_section->save()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Dzēš sadaļu un tās saturu.
     *
     * @param $id - dzēšamās sadaļas id
     */
    public static function deleteSection($id)
    {
        $section = Section::findOne($id);

        if (isset($section)) {
            $children = Section::findChildren($section->id);
            if (!empty($children)) {
                foreach ($children as $child) {
                    Section::deleteSection($child->id);
                }
            }
            switch ($section->type) {
                case 'html':
                    foreach ($section->html as $html) $html->deleteHtml($html->id);
                    break;
            }
            if ($section->image) FileControl::deleteFile(Yii::getAlias('@storage') . '/' . self::IMG_DIR . '/' . $section->image);
            if ($section->delete()) {
                return 0;
            } else {
                return 1;
            }
        }
    }

    public static function generateSiteTreeStructure(array &$array)
    {
        foreach ($array as $index => &$section) {
            $section->setChildren($array);
        }
        foreach ($array as $key => $s) {
            if ($s->parent_id != null) {
                unset($array[$key]);
            }
        }
    }

    /**
     * @param array $children
     */
    public function setChildren(&$sections, $parentSlug = null)
    {
        $id = $this->id;
        $children = &$this->children;
        if (!$parentSlug) {
            $this->fullSlug = '/' . $this->lang . '/' . $this->slug;
        } else {
            $this->fullSlug = $parentSlug . '/' . $this->slug;
        }
        foreach ($sections as $index => $section) {
            if ($section->parent_id == $id) {
                unset($sections[$index]);
                $section->setChildren($sections, $this->fullSlug);
                $children[] = $section;
            }
        }
        return $sections;
    }

    public static function findInCollection(array $modelArray, array $constraints)
    {
        foreach ($modelArray as $model) {
            $section = $model->findFromConstraints($constraints);
            if ($section) {
                return $section;
            }
        }
        return false;
    }

    protected function findFromConstraints(array $constraints)
    {
        if ($this->children) {
            foreach ($this->children as $child) {
                $childSection = $child;
                break;
            }
            $section = $childSection->findInCollection($this->children, $constraints);
            if ($section) {
                return $section;
            }
        }
        foreach ($constraints as $field => $constraint) {
            if ($constraint === '') {
                if (!$this->$field) {
                    $section = $this;
                } else {
                    $section = false;
                    break;
                }
            } elseif ($this->$field && $this->$field == $constraint) {
                $section = $this;
            } else {
                $section = false;
                break;
            }
        }
        if ($section) {
            return $section;
        } else {
            return false;
        }
    }

    public function getSectionBySlugs(array $slugs)
    {
        $sections = self::find()->where(['lang' => Yii::$app->language])->andWhere(['in', 'slug', $slugs])->all();
        for ($i = 0; $i < count($slugs); $i++) {
            if ($slugs[$i] != null) {
                $this->prevSection = $this->currSection;
                if ($this->prevSection) {
                    $this->currSection = $this->findInCollection($sections, ['slug' => $slugs[$i], 'parent_id' => $this->prevSection->id, 'active' => 1]);
                } else {
                    $this->currSection = $this->findInCollection($sections, ['slug' => $slugs[$i], 'parent_id' => '', 'active' => 1]);
                }
                if (!$this->currSection && !$this->prevSection) {
                    break;
                }
            } else {
                break;
            }
        }
        if (!$this->currSection && $this->prevSection && in_array($this->prevSection->type, self::$articleTypes)) {
            $this->articleSlug = $slugs[$i - 1];
            return;
        } elseif (!$this->currSection) {
            throw new NotFoundHttpException(Yii::t('yii', 'Page not found.'), 404);
        } else {
            return;
        }
    }

    public function getFrontendContent()
    {
        switch ($this->currSection->type) {
            case 'html' :
                return Html_::findOne(['section_id' => $this->currSection->id]);
                break;
            case 'gdpr':
                return ['content' => Settings::find()->where(['key' => 'gdpr-content-' . $this->currSection->id])->one(),
                    'section' => Section::find()->where(['id' => $this->currSection->id])->one()];
                break;
            default:
                throw new NotFoundHttpException(Yii::t('yii', 'Page not found.'), 404);
        }
    }

    public static function findChildren($id = null, $active = 0)
    {
        if ($id == null) $id = $this->id;
        $query = self::find()->where(['parent_id' => $id]);
        if ($active) $query->andWhere(['active' => 1]);
        return $query->orderBy('order_by ASC')->all();
    }

    /**
     * Rekurs�va funkcija:
     * Sagatavo mas�vu ar visu sada�as vec�ku id.
     * Pirmo reizi jau j�padod $section->parend_id, nevis $section->id!
     *
     * @param       $parent_id
     * @param array $parents_ids
     *
     * @return array
     */
    public static function getParentsIds($parent_id, $parents_ids = [])
    {
        $section = Section::findOne($parent_id);
        if (isset($section)) {
            $parents_ids[$section->id] = 1;
            if ($section->parent_id) $parents_ids = Section::getParentsIds($section->parent_id, $parents_ids);
        }

        return $parents_ids;

    }

    /**
     * Sagatavo HTML lapas koka zara vec�ka izv�lei sada�� site-tree.
     *
     * @param     $tree
     * @param int $depth
     *
     * @return string
     */
    public static function renderAdminParentSelect($tree, $depth = 0)
    {
        $parent_depth_limit = Yii::$app->params['cmsConfig']['site-tree-depth'] - 1;
        if ($depth < $parent_depth_limit) {
            return Yii::$app->controller->renderPartial('/site-tree/widgets/parent-select', array(
                'parent_depth_limit' => $parent_depth_limit,
                'tree' => $tree,
                'depth' => $depth,
            ));
        }
    }

    public static function renderPermissionsCheckboxes($tree, $user = null, $folder = 'users', $group = null)
    {
        return Yii::$app->controller->renderPartial('/' . $folder . '/widgets/permissions-checkboxes', array(
            'tree' => $tree,
            'depth' => 0,
            'parent' => 0,
            'user' => $user,
            'folder' => $folder,
            'group' => $group,
        ));
    }

    public static function findBranchDepth($branch, $depth = 0)
    {
        if ($branch->parent) {
            $depth = self::findBranchDepth($branch->parent, $depth + 1);
        }

        return $depth;
    }

    /**
     * Rekurs�va funkcija.
     * Atgrie� lapas koka maksim�lo dzi�umu.
     *
     * @param     $tree
     * @param int $depth
     *
     * @return int|mixed|string
     */
    public static function findSiteTreeDepth($tree, $depth = 0)
    {
        $max = $depth;
        foreach ($tree as $branch) {

            if (empty($branch)) return '';

            if (is_array($branch->children)) {
                $max = max($max, Section::findSiteTreeDepth($branch->children, $depth + 1));
            }
        }

        return $max;
    }

    public function hasChildren($active = 0)
    {
        $query = Section::find()->where(['parent_id' => $this->id]);
        if ($active) $query->andWhere(['active' => 1]);
        return $query->exists();
    }

    public static function parents($active = 0)
    {
        $query = self::find()->where(['parent_id' => null]);
        if ($active) $query->andWhere(['active' => 0]);
        return $query->orderBy('order_by ASC')->all();
    }

    public function getContentTypeSection(string $type): Section
    {
        return Section::findInCollection(Yii::$app->view->params['site-tree'], ['type' => $type]);
    }
}
