<?php

namespace wdigital\cms\siteTree\models;


use yii\db\ActiveRecord;

class HtmlTranslation extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return '{{%html_translation}}';
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['html_id', 'language_id'], 'integer'],
            [['content'], 'string'],
            [['html_id', 'language_id'], 'unique', 'targetAttribute' => ['html_id', 'language_id']],
            [['html_id'], 'exist', 'skipOnEmpty' => true, 'targetClass' => Html::class, 'targetAttribute' => ['html_id' => 'id']],
            [['language_id'], 'exist', 'skipOnError' => true, 'targetClass' => \Yii::$app->getModule('language')->languageClass, 'targetAttribute' => ['language_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'html_id' => \Yii::t('site-tree', 'Html ID'),
            'language_id' => \Yii::t('site-tree', 'Language ID'),
            'content' => \Yii::t('site-tree', 'Content'),
        ];
    }
}