<?php

namespace wdigital\cms\siteTree\models;

use yii\db\ActiveRecord;
use yii2tech\ar\variation\VariationBehavior;

/**
 * This is the model class for table "html".
 *
 * @property int $id
 * @property int $section_id
 *
 * @property Section $section
 * @property HtmlTranslation[] $htmlTranslations
 */
class Html extends ActiveRecord
{

    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return '{{%html}}';
    }

    /**
     * @return array
     */
    public function behaviors(): array
    {
        return [
            'translations' => [
                'class' => VariationBehavior::class,
                'variationsRelation' => 'htmlTranslations',
                'defaultVariationRelation' => 'defaultTranslation',
                'variationOptionReferenceAttribute' => 'language_id',
                'optionModelClass' => \Yii::$app->getModule('language')->languageClass,
                'defaultVariationOptionReference' => \Yii::$app->getModule('language')->languageClass::getIdFromCode(\Yii::$app->language),
                'variationModelDefaultAttributes' => [
                    'content' => '',
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['section_id'], 'required'],
            [['section_id'], 'integer'],
            [['section_id'], 'exist', 'skipOnError' => true, 'targetClass' => \Yii::$app->getModule('site-tree')->sectionClass, 'targetAttribute' => ['section_id' => 'id']],
            ['content', 'safe'],
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getHtmlTranslations(): \yii\db\ActiveQuery
    {
        return $this->hasMany(HtmlTranslation::class, ['html_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDefaultTranslation(): \yii\db\ActiveQuery
    {
        return $this->hasDefaultVariationRelation();
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSection(): \yii\db\ActiveQuery
    {
        return $this->hasOne(\Yii::$app->getModule('site-tree')->sectionClass, ['id' => 'section_id']);
    }

    public function changeOrder($section, $post)
    {
        $model = new Section();
        $updated_section = $section;
        if ($post['new_parent'] == '#') {
            $updated_section->parent_id = null;
        } else {
            $updated_section->parent_id = $post['new_parent'];
        }
        if ($post['new_parent'] == '#') {
            $sections = $model->parents();
            foreach ($sections as $s) {
                if ($s->order_by >= $post['position']) {
                    $s->order_by += 1;
                    $s->save();
                }
            }
            $updated_section->order_by = $post['position'];
        } else {
            $sections = $model->find()->where(['parent_id' => $post['new_parent']])->all();
            foreach ($sections as $s) {
                if ($s->order_by >= $post['position']) {
                    $s->order_by += 1;
                    $s->save();
                }
            }
            $updated_section->order_by = $post['position'];
        }
        $updated_section->save();
    }
}
