<?php

namespace wdigital\cms\siteTree\controllers;

use common\components\FileControl;
use common\components\Image;
use wdigital\cms\i18n\models\Language;
use wdigital\cms\siteTree\models\Card;
use wdigital\cms\siteTree\models\Category;
use wdigital\cms\siteTree\models\Consultation;
use wdigital\cms\siteTree\models\Logo;
use wdigital\cms\siteTree\models\Promotion;
use wdigital\cms\siteTree\models\PromotionSpecial;
use wdigital\cms\siteTree\models\Settings;
use wdigital\cms\siteTree\models\Shop;
use wdigital\cms\siteTree\models\Vacancy;
use wdigital\cms\siteTree\models\VacancySubmit;
use Yii;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\UploadedFile;

class SettingsController extends Controller {

    public function beforeAction($action) {
        return parent::beforeAction($action);
    }
    public function behaviors(){
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['admin'],
                    ],
                    [
                        'actions'=> ['email-update'],
                        'allow' => true,
                        'roles' => ['email-update'],
                    ],
                    [
                        'actions'=> ['background-home-image'],
                        'allow' => true,
                        'roles' => ['background-home-image'],
                    ],
                    [
                        'actions'=> ['special-product-update'],
                        'allow' => true,
                        'roles' => ['special-product-update'],
                    ],
                ]
            ]
        ];
    }

    public function actionEmailUpdate() {
        $post = Yii::$app->request->post();
        $model = new Settings();
        $model = $model::find()->where(['key' => 'notification-email'])->one();
        if(!$model){
            $model = new Settings();
            $value = $post['Settings']['value'];
            $key = 'notification-email';
            $model->createNew($key,$value);
        }else{
            $value = 0;
            $key = 'notification-email';
            $model->updateSetting($key,$value,$post,$model);
        }

        return $this->redirect('/'.Yii::$app->language);
    }

    public function actionBackgroundHomeImage() {
        $post = Yii::$app->request->post();
        $model = new Settings();
        $image = UploadedFile::getInstance($model, 'image');
        $model = $model::find()->where(['key' => 'background_image'])->one();
        if(!$model){
            $model = new Settings();
            $image->name = date('Y-m-d_H:i:s').$image->name;
            FileControl::uploadFile($image, 'uploads/settings/'. $image->name);
            Image::resizeImage(Yii::getAlias('@frontend').'/web/'.'uploads/settings/' .'/'. $image->name, intval($post['x']), intval($post['y']), intval($post['w']), intval($post['h']));
            $value = $image->name;
            $key = 'background_image';
            $model->createNew($key,$value);
        }else{
            $image->name = date('Y-m-d_H:i:s').$image->name;
            FileControl::uploadFile($image, 'uploads/settings/'. $image->name);
            Image::resizeImage(Yii::getAlias('@frontend').'/web/'.'uploads/settings/' .'/'. $image->name, intval($post['x']), intval($post['y']), intval($post['w']), intval($post['h']));
            $post['value'] = $image->name;
            $value = 0;
            $key = 'background_image';
            $model->updateSetting($key,$value,$post,$model);
        }

        return $this->redirect('/'.Yii::$app->language);
    }
    public function actionSpecialProductUpdate(){
        $post = Yii::$app->request->post();
        if(isset($post['promotion_1'])){
            if($post['promotion_1'] != 'text'){
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '1'])->one();
                if (!$special) {
                    $special = new PromotionSpecial();
                    $special->promotion_id = $post['promotion_1'];
                    $special->order_by = 1;
                    $special->save();
                } else {
                    $special->promotion_id = $post['promotion_1'];
                    $special->order_by = 1;
                    $special->save();
                }
            } else {
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '1'])->one();
                if ($special) {
                    $special->delete();
                }
            }
        }
        if(isset($post['promotion_2'])){
            if($post['promotion_2'] != 'text') {
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '2'])->one();
                if (!$special) {
                    $special = new PromotionSpecial();
                    $special->promotion_id = $post['promotion_2'];
                    $special->order_by = 2;
                    $special->save();
                } else {
                    $special->promotion_id = $post['promotion_2'];
                    $special->order_by = 2;
                    $special->save();
                }
            }else {
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '2'])->one();
                if ($special) {
                    $special->delete();
                }
            }
        }
        if(isset($post['promotion_3'])){
            if($post['promotion_3'] != 'text') {
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '3'])->one();
                if (!$special) {
                    $special = new PromotionSpecial();
                    $special->promotion_id = $post['promotion_3'];
                    $special->order_by = 3;
                    $special->save();
                } else {
                    $special->promotion_id = $post['promotion_3'];
                    $special->order_by = 3;
                    $special->save();
                }
            }else{
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '3'])->one();
                if ($special) {
                    $special->delete();
                }
            }
        }
        if(isset($post['promotion_4'])) {
            if ($post['promotion_4'] != 'text') {
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '4'])->one();
                if (!$special) {
                    $special = new PromotionSpecial();
                    $special->promotion_id = $post['promotion_4'];
                    $special->order_by = 4;
                    $special->save();
                } else {
                    $special->promotion_id = $post['promotion_4'];
                    $special->order_by = 4;
                    $special->save();
                }
            } else{
                $special = new PromotionSpecial();
                $special = $special::find()->where(['order_by' => '4'])->one();
                if ($special) {
                    $special->delete();
                }
            }
        }
        return $this->redirect('/'.Yii::$app->language);
    }



}
