<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\i18n\models\Language;
use wdigital\cms\siteTree\models\Html_content;
use wdigital\cms\siteTree\models\Section;
use common\models\Settings;
use common\models\User;
use common\models\UserGroup;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\Url;
use yii\web\Controller;

class HtmlController extends Controller {

    public function beforeAction($action) {

        return parent::beforeAction($action);

    }
    public function behaviors(){
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['admin'],
                    ],
                    [
                        'actions'=> ['edit'],
                        'allow' => true,
                        'roles' => ['html-edit-content'],
                    ],
                ]
            ]
        ];
    }

    public function actionAdd() {
        $csrftoken = Yii::$app->request->validateCsrfToken();
        $post = Yii::$app->request->post();
        if ($post) {
            $section = new Section();
            $section->createNew($post);
            return $this->redirect(Url::to(['index']));
        }
    }

    public function actionEdit($id) {
        $post = Yii::$app->request->post();
        if ($post) {
            $html = Html_content::find()->where(['id'=>$id])->one();
            $html->scenario = Html_content::SCENARIO_UPDATE;
            $html->load($post);
            if($html->save()) {
                return $this->redirect(Url::to(['default/index', 'id' => $id]));
            }
        } else {
            $model = new Html_content();
            $html = $model->find()->where(['section_id'=>$id])->one();
            return $this->render('@wd-site-tree/views/section/html/edit', [
                    'model' => $model,
                    'html' => $html
                ]
            );
        }
    }




}
