<?php
namespace wdigital\cms\siteTree\models;

use common\components\FileControl;
use common\components\Image;
use common\models\ContentTypes;
use common\models\ContentTypes\Contact;
use wdigital\cms\siteTree\models\Html_content;
use common\models\ContentTypes\News;
use common\models\ContentTypes\President;
use common\models\ContentTypes\SocialPost;
use common\models\ParentModel;
use Yii;
use yii\caching\TagDependency;
use yii\db\ActiveRecord;
use yii\helpers\Html;
use yii\rest\ActiveController;
use yii\web\NotFoundHttpException;
use yii\web\ServerErrorHttpException;

/**
 * @property int    $id
 * @property int    $parent_id
 * @property string $name
 * @property string $slug
 * @property string $type
 * @property bool   $active
 * @property int    $order_by
 * @property string $lang
 * @property string $redirect_to
 * @property string $image
 */
class Section extends ActiveRecord {

    const TABLE = '{{%sections}}';
    const IMG_DIR = 'uploads/sections';
    public static $tree = null;
    public $children = [];
    public $depth;
    public $path;
    public $currSection = null;
    public $prevSection = null;
    public $articleSlug = null;
    public $fullSlug;
    public $active = 0;
    public $lang = 'lv';

	public function getParent()
	{
		return $this->hasOne(self::className(), ['id' => 'parent_id'])->from(['parent' => self::tableName()]);
	}

	public function getHtml()
	{
		return $this->hasMany(Html_content::className(), ['section_id' => 'id']);
	}

    public function getChilds()
	{
		return $this->hasMany(self::className(), ['parent_id' => 'id'])->from(['child' => self::tableName()])->where(['child.active' => 1]);
	}

    public function getImage($w = null, $h = null, $ratio = null)
    {
        return self::irsPicture(self::IMG_DIR, $this->image, $w, $h, $ratio);
    }

    public static function irsPicture($folder, $img, $w= null, $h = null, $type = null) {
        if ($type == 'c' || $type == 'r') {
            if ($img != null && file_exists(Yii::getAlias('@storage').'/'.$folder .'/'. $img)) {
                return "/media/{$type}/{$w}/{$h}/{$folder}/{$img}";
            } else {
                return "/media/{$type}/{$w}/{$h}/img/prezidenta_karogs.jpg";
            }
        } else {
            if ($img != null && file_exists(Yii::getAlias('@storage').'/'.$folder.'/'. $img)) {
                return "/storage/{$folder}/{$img}";
            } else {
                return '/storage/img/prezidenta_karogs.jpg';
            }
        }
    }

    public function rules() {
        return [
            [['parent_id', 'lang'], 'safe'],
            [['name', 'slug', 'type'], 'required'],
            ['image', 'file', 'extensions' => ['png', 'jpg', 'gif', 'jpeg']],
            ['image', 'image', 'minWidth' => 1920, 'minHeight' => 250],
        ];
    }
    public function createNew($post){
	    $section = new self();
	    $section->load($post);
	    if($section->parent_id == 0){
	        $section->parent_id = null;
        }
        $last_order = self::find()->orderBy('order_by DESC')->one();
        if($last_order != null){
            $section->order_by = $last_order->order_by + 1;
        }else {
            $section->order_by = 1;
        }
        $section->lang = Yii::$app->language;
	    if($section->save()){
            if($section->type == 'html') {
                $html = new Html_content();
                $html->scenario = Html_content::SCENARIO_SAVE;
                $html->createNew($section->id, '');
            }
	        return true;
        }else{
	        return false;
        }
    }

    public function changeOrder($section, $post){
        $model = new Section();
        $updated_section = $section;
        if($post['new_parent'] == '#'){
            $updated_section->parent_id = null;
        }else{
            $updated_section->parent_id = $post['new_parent'];
        }
        if($post['new_parent'] == '#'){
            $sections = $model->parents();
            foreach($sections as $s){
                if($s->order_by >= $post['position']){
                    $s->order_by += 1;
                    $s->save();
                }
            }
            $updated_section->order_by = $post['position'];
        }else{
            $sections = $model->find()->where(['parent_id' => $post['new_parent']])->all();
            foreach($sections as $s){
                if($s->order_by >= $post['position']){
                    $s->order_by += 1;
                    $s->save();
                }
            }
            $updated_section->order_by = $post['position'];
        }
        $updated_section->save();
    }


    /**
     * Dzēš sadaļu un tās saturu.
     *
     * @param $id - dzēšamās sadaļas id
     */
    public static function deleteSection($id) {
        $section = Section::findOne($id);

        if (isset($section)) {
            $children = Section::findChildren($section->id);
            if (!empty($children)) {
                foreach($children as $child) {
                    Section::deleteSection($child->id);
                }
            }
            switch ($section->type){
                case 'html':
                    foreach ($section->html as $html) $html->deleteHtml($html->id);
                    break;
            }
            if($section->image)FileControl::deleteFile(Yii::getAlias('@storage').'/'.self::IMG_DIR.'/'. $section->image);
            Yii::$app->getSession()->setFlash('success', 'Sadaļa izdzēsta!');
            $section->delete();
        }
    }



    /**
     * Rekurs�va funkcija:
     * Sagatavo mas�vu ar visu sada�as vec�ku id.
     * Pirmo reizi jau j�padod $section->parend_id, nevis $section->id!
     *
     * @param       $parent_id
     * @param array $parents_ids
     *
     * @return array
     */
    public static function getParentsIds($parent_id, $parents_ids = []) {
        $section = Section::findOne($parent_id);
        if (isset($section)) {
            $parents_ids[$section->id] = 1;
            if ($section->parent_id) $parents_ids = Section::getParentsIds($section->parent_id, $parents_ids);
        }

        return $parents_ids;

    }


    /**
     * Sagatavo HTML lapas koka zara vec�ka izv�lei sada�� site-tree.
     *
     * @param     $tree
     * @param int $depth
     *
     * @return string
     */
    public static function renderAdminParentSelect($tree, $depth = 0) {
        $parent_depth_limit = Yii::$app->params['cmsConfig']['site-tree-depth']-1;
        if($depth < $parent_depth_limit){
            return Yii::$app->controller->renderPartial('/site-tree/widgets/parent-select', array(
                'parent_depth_limit' => $parent_depth_limit,
                'tree'  => $tree,
                'depth' => $depth,
            ));
        }
    }

    public static function renderPermissionsCheckboxes($tree, $user = null, $folder = 'users', $group = null){
        return Yii::$app->controller->renderPartial('/'.$folder.'/widgets/permissions-checkboxes', array(
            'tree'  => $tree,
            'depth' => 0,
            'parent' => 0,
            'user' => $user,
            'folder' => $folder,
            'group' => $group,
        ));
    }

    public static function findBranchDepth($branch, $depth = 0) {
        if ($branch->parent) {
            $depth = self::findBranchDepth($branch->parent, $depth + 1);
        }

        return $depth;
    }


    /**
     * Rekurs�va funkcija.
     * Atgrie� lapas koka maksim�lo dzi�umu.
     *
     * @param     $tree
     * @param int $depth
     *
     * @return int|mixed|string
     */
    public static function findSiteTreeDepth($tree, $depth = 0) {
        $max = $depth;
        foreach($tree as $branch) {

            if (empty($branch)) return '';

            if (is_array($branch->children)) {
                $max = max($max, Section::findSiteTreeDepth($branch->children, $depth + 1));
            }
        }

        return $max;
    }

    public function hasChildren($active = 0){
        $query = Section::find()->where(['parent_id' => $this->id]);
        if($active) $query->andWhere(['active' => 1]);
        return $query->exists();
    }

    public static function findChildren($id = null, $active = 0) {
        if($id == null) $id = $this->id;
        $query = self::find()->where(['parent_id' => $id]);
        if($active) $query->andWhere(['active' => 1]);
        return $query->orderBy('order_by ASC')->all();
    }




    public static function parents($active = 0) {
        $query = self::find()->where(['parent_id' => null]);
        if($active) $query->andWhere(['active' => 0]);
        return $query->orderBy('order_by ASC')->all();
    }

    public static function customParents($active = 0, $section) {
        $query = self::find()->where(['parent_id' => $section->id]);
        if($active) $query->andWhere(['active' => 1]);
        return $query->orderBy('order_by ASC')->all();
    }

    public static function toggle($id) {
        $section         = Section::findOne(['id' => $id]);
        $section->active = 1 - $section->active;
        $section->save();
    }


    public function getHref($slug = '') {
        $slug = t('sections.slug.'.$this->id) . '/' . $slug;
        if(substr($slug,-1) == '/') $slug = substr($slug,0,-1);
        if($this->parent_id == 0) return '/' . Yii::$app->language . '/' . $slug;
        else {
            if(substr($slug,-1) == '/') $slug = substr($slug,0,-1);
            return $this->getParent()->getHref($slug);
        }
    }

	public function getLangHrefs($lang = false, $slug = '') {
    	if(!$lang) $lang=Yii::$app->language;
		$slug = $this->slug . '/' . $slug;
		if(substr($slug,-1) == '/') $slug = substr($slug,0,-1);
		if($this->parent_id == 0) return '/' . $lang . '/' . $slug;
		else {
			if(substr($slug,-1) == '/') $slug = substr($slug,0,-1);
			return $this->parent->getLangHrefs($lang, $slug);
		}
	}

    public static function handleContent($data, $id) {
        switch ($data['type']) {
            case "html":
                return ContentTypes\HTML::newOrEdit($data, $id);
                break;
            case "president":
                return ContentTypes\President::newOrEdit($data, $id);
                break;
            case "news":
                return ContentTypes\News::newOrEdit($data, $id);
                break;
            case "blogs":
                return ContentTypes\Blogs::newOrEdit($data, $id);
                break;
			case "blog_topic":
				return BlogTopic::newOrEdit($data, $id);
				break;
            case "gallery":
                return Gallery::newOrEdit($data, $id);
                break;
			case "news_tag":
				return NewsTag::newOrEdit($data, $id);
				break;
            case "award-type":
				return AwardType::newOrEdit($data, $id);
				break;
            case "award-recipient":
				return AwardRecipient::newOrEdit($data, $id);
				break;
            case "social-post":
				return SocialPost::edit($data, $id);
				break;
            case "contact":
				return Contact::newOrEdit($data, $id);
				break;
            default:
                break;
        }
    }

    public function changeContentType($newType, $new = 0, $release = 0) {
        if(!$new || $release){
            switch ($this->type) {
                case 'html':
                    ContentTypes\HTML::deleteBySection($this->id);
                    break;
                case 'purchases':
                    ContentTypes\Purchase::deleteBySection($this->id);
                    break;
                case "contacts":
                    break;
                case "currents":
                    ContentTypes\Currents::deleteBySection($this->id);
                    break;
                default:
                    break;
            }
        }
//        if(!$release)
//        switch ($newType) {
//            case 'html':
//                ContentTypes\HTML::newOrEdit([
//                    'section_id'        => $this->id,
//                    'content' => '',
//                ]);
//                break;
//            default:
//                break;
//        }
    }

    public function getHtmlContentId() {
        return ContentTypes\HTML::findOne(['section_id' => $this->id])->id;
    }

    public function getContent(){
        switch($this->type){
            case 'html' :
                return ContentTypes\HTML::findOne(['section_id' => $this->id]);
            case 'news':
                return ContentTypes\News::findBySection();
                break;
            case 'president':
                return ContentTypes\President::findBySection();
                break;
            case 'gallery':
                return Gallery::findBySection($this);
                break;
            case 'award-type':
                return AwardType::findBySection($this);
                break;
            case 'social-post':
                return ContentTypes\SocialPost::getBackendContent();
                break;
            case 'contacts':
                return Contact::getBackendContent();
                break;
            default:
                return 1;
        }
    }

    public function getFrontendContent()
    {
        switch ($this->currSection->type) {
            case 'html' :
                return ContentTypes\HTML::findOne(['section_id' => $this->currSection->id]);
                break;
            case 'news':
                return ContentTypes\News::getFrontendContent($this);
                break;
            case 'president':
                return President::getFrontendContent($this);
                break;
            case 'calendar':
                    $calendar = new CalendarFrontEnd;
                    $return['regular'] = $calendar->generateFrontEndCalendar();
                    $return['compact'] = $calendar->generateCompactCalendar();
                return $return;
                break;
            case 'gallery':
                return Gallery::getFrontendContent();
                break;
            case 'gallery-archive':
                return Gallery::getFrontendArchiveContent();
                break;
            case 'contacts':
                return Contact::getFrontendContent();
                break;
            case 'award-type':
                return AwardType::getFrontendContent();
                break;
            case 'site-map':
                return true;
                break;
            case 'social-post':
                return SocialPost::getFrontendContent();
                break;
            default:
                throw new NotFoundHttpException(Yii::t('yii', 'Page not found.'), 404);
        }
    }

    public static function findBySlugs($slugs){
    	$lang = Yii::$app->language;
        $section = null;
        $prevSection = null;
		if ($lang == Yii::$app->sourceLanguage) {
			for ($i = 0; $i < count($slugs); $i++) {

				if ($slugs[$i] != null) {
					$prevSection = $section;
					if ($prevSection)
						$section = self::find()->where(['slug' => $slugs[$i], 'parent_id' => $prevSection->id])->one();
					else
						$section = self::find()->where(['slug' => $slugs[$i], 'parent_id' => null])->one();

				} else break;

			}
		} else {
			for ($i = 0; $i < count($slugs); $i++) {
				if ($slugs[$i] != null) {
					$prevSection = $section;
					$translation = Translation::find()->with('section')
						->where(['translation' => $slugs[$i],
							't_column' => 'slug',
							't_table' => self::tableName(),
							'lang' => $lang])->one();
					isset($translation->section) ? $section = $translation->section : $section = null;
				} else break;
			}
		}
		if(!$section && $prevSection && in_array($prevSection->type, self::$articleTypes))
			return ['section' => $prevSection, 'articleSlug' => $slugs[$i-1]];
		elseif(!$section)
			throw new NotFoundHttpException();
		else
			return ['section' => $section];
    }

    public function getSectionBySlugs(array $slugs)
    {
        $sections = self::find()->where(['lang' => Yii::$app->language])->andWhere(['in', 'slug', $slugs])->all();
        for ($i = 0; $i < count($slugs); $i++) {
            if ($slugs[$i] != null) {
                $this->prevSection = $this->currSection;
                if ($this->prevSection) {
                    $this->currSection = $this->findInCollection($sections, ['slug' => $slugs[$i], 'parent_id' => $this->prevSection->id, 'active' => 1]);
                } else {
                    $this->currSection = $this->findInCollection($sections, ['slug' => $slugs[$i], 'parent_id' => '', 'active' => 1]);
                }
                if(!$this->currSection && !$this->prevSection){
                    break;
                }
            } else {
                break;
            }
        }
        if (!$this->currSection && $this->prevSection && in_array($this->prevSection->type, self::$articleTypes)) {
            $this->articleSlug = $slugs[$i-1];
            return;
        } elseif (!$this->currSection) {
			throw new NotFoundHttpException(Yii::t('yii', 'Page not found.'), 404);
        } else {
			return;
        }
    }

    public function getParentZeroChildren($active = 0) {
        $parentZero = $this;//TODO: ERROR HERE BREDCRUMBS
        while ($parentZero->parent_id != 0 && !$parentZero->parentIsCustomFrontpage()){
            $parentZero = self::findOne($parentZero->parent_id);
        }
        $return = self::find()->where(['parent_id' => $parentZero->id]);
        if($active){
            $return->andWhere(['active' => 1]);
        }
        return $return->orderBy('order_by ASC')->all();
    }

    public function isCurrent($current){
        $ids = [];
        $section = $current;
        while($section){
            $ids[] = $section->id;
            $section = self::findOne($section->parent_id);
        }
        return in_array($this->id, $ids);

    }
    public function getAscParents($parents = [])
    {
        if($this->parent_id == 0 || $this->type == "custom_frontpage") return $parents;
        else {
            $parent = $this->getParent();
            array_unshift($parents, $parent);
            return $parent->getAscParents($parents);
        }
    }

    public function isUnderCustomFrontPage(){
        $parent = self::findOne($this->parent_id);
        while($parent && $parent->id != 0){
            if($parent->type == "custom_frontpage")
                return $parent;
            else
                $parent = self::findOne($parent->parent_id);
        }
        return null;
    }

    public function parentIsCustomFrontpage(){
        return self::findOne($this->parent_id)->type == "custom_frontpage";
    }
    public static function getNewsSections(){
        $sections = self::find()->where(['type' => "news"])->all();

        $return = [];
        foreach ($sections as $key => $section){
            $return[$key]['object'] = $section;
            $return[$key]['id'] = $section->id;
            $return[$key]['name'] = $section->name;

            $parent = self::findOne($section->parent_id);
            while($parent){
                $return[$key]['name'] = $parent->name . ' / ' . $return[$key]['name'];
                $parent = self::findOne($parent->parent_id);
            }
        }
        return $return;
    }

    public static function getGallerySections(){
        $sections = self::find()->where(['type' => "galleries"])->all();

        $return = [];
        foreach ($sections as $key => $section){
            $return[$key]['object'] = $section;
            $return[$key]['id'] = $section->id;
            $return[$key]['name'] = $section->name;

            $parent = self::findOne($section->parent_id);
            while($parent){
                $return[$key]['name'] = $parent->name . ' / ' . $return[$key]['name'];
                $parent = self::findOne($parent->parent_id);
            }
        }
        return $return;
    }

    public static function getCurrentsSections(){
        $sections = self::find()->where(['type' => "currents"])->all();

        $return = [];
        foreach ($sections as $key => $section){
            $return[$key]['object'] = $section;
            $return[$key]['id'] = $section->id;
            $return[$key]['name'] = $section->name;

            $parent = self::findOne($section->parent_id);
            while($parent){
                $return[$key]['name'] = $parent->name . ' / ' . $return[$key]['name'];
                $parent = self::findOne($parent->parent_id);
            }
        }
        return $return;
    }

    public static function getHtmlSections(){
        $sections = self::find()->where(['type' => "html"])->all();

        $return = [];
        foreach ($sections as $key => $section){
            $return[$key]['object'] = $section;
            $return[$key]['id'] = $section->id;
            $return[$key]['name'] = $section->name;

            $parent = self::findOne($section->parent_id);
            while($parent){
                $return[$key]['name'] = $parent->name . ' / ' . $return[$key]['name'];
                $parent = self::findOne($parent->parent_id);
            }
        }
        return $return;
    }

    public static function getApplicationSections(){
        $sections = self::find()->where(['type' => "application"])->all();

        $return = [];
        foreach ($sections as $key => $section){
            $return[$key]['object'] = $section;
            $return[$key]['id'] = $section->id;
            $return[$key]['name'] = $section->name;

            $parent = self::findOne($section->parent_id);
            while($parent){
                $return[$key]['name'] = $parent->name . ' / ' . $return[$key]['name'];
                $parent = self::findOne($parent->parent_id);
            }
        }
        return $return;
    }



    public static function getCalendarSections(){
        $sections = self::find()->where(['type' => "calendar"])->all();

        $return = [];
        foreach ($sections as $key => $section){
            $return[$key]['object'] = $section;
            $return[$key]['id'] = $section->id;
            $return[$key]['name'] = $section->name;

            $parent = self::findOne($section->parent_id);
            while($parent){
                $return[$key]['name'] = $parent->name . ' / ' . $return[$key]['name'];
                $parent = self::findOne($parent->parent_id);
            }
        }
        return $return;
    }

    public function getTemplate(){
        $templateId = $this->getSetting('template');
        if($templateId){
            $template = CustomFrontpageTemplate::findOne($templateId);
            if($template) return $template;
        }
        return null;
    }
    public static function getSiteMapLink(){
        $section = self::findOne(['type' => 'site-map']);
        if($section) return $section->getHref();
        else return '';
    }
    public function getRegisterLoginContent($section) {
        if($section == 'register') {
            echo 'hi';
        }else {
            echo 'hello';
        }
    }

    public function findArticleBySlug($slug)
    {
        $array = [
            'president' => President::class,
            'news' => News::class,
            'html' => HTML::class,
            'calendar' => CalendarFrontEnd::class,
            'gallery' => Gallery::class,
        ];
        $classname = $array[$this->prevSection->type];
        if ($classname){
            $results = $classname::findBySlug($slug);
            if($results['main']){
                Yii::$app->view->params['current-section']['name'] =
                    isset($results['main']->title) ?
                    $results['main']->title :
                    $results['main']->fullname;
            }
        } else {
            $results = false;
        }
        return $results;
    }

    /**
     * @param array $children
     */
    public function setChildren($sections)
    {
        $id = $this->id;
        $children = &$this->children;
        foreach ($sections as $index => $section) {
            if ($section->parent_id == $id) {
                unset($sections[$index]);
                $section->setChildren($sections);
                $children[] = $section;
            }
        }
        return $sections;
    }

    /**
     * Sets full slug for children
     */
    public function setChildrenFullSlug($children, $parent_fullSlug) {
        foreach($children as $child){
            $child->fullSlug = $parent_fullSlug. '/'. $child->slug;
            if($child->children != null){
                $child->setChildrenFullSlug($child->children, $child->fullSlug);
            }
        }
    }

    public static function checkNavStatus($data, $id)
    {
        if (isset($data['nav'])) {
            $setting = new Settings();
            $setting = $setting->getSetting('nav');
            $value = $setting->getDecodedValue();
            $index = array_search($id, $value);
            if(!$index){
                $value[] = $id;
            }
            $setting->value = json_encode($value);
            return $setting->save();
        } else {
            $setting = new Settings();
            $setting = $setting->getSetting('nav');
            $value = $setting->getDecodedValue();
            $index = array_search($id, $value);
            if($index){
                unset($value[$index]);
                $value = array_values($value);
            }
            $setting->value = json_encode($value);
            return $setting->save();
        }
    }
}
