<?php

namespace wdigital\cms\siteTree\controllers;

use backend\controllers\BackendParentController;
use wdigital\cms\siteTree\models\Section;
use common\models\Settings;
use common\models\User;
use common\models\UserGroup;
use Yii;
use yii\helpers\Url;
use yii\web\HttpException;
use yii\web\NotFoundHttpException;
use yii\web\Response;
use function json_encode;

class SiteTreeController extends BackendParentController {

    public function beforeAction($action) {
        if(!User::checkAccess('admin', 'site-tree')){
            $this->redirect(Url::to(['/admin/insufficient-permissions', 'lang'=>Yii::$app->language]));
            return false;
        }
        return parent::beforeAction($action);
    }

    public function actionIndex() {
        $section = new Section();
        $sections = $section::find()->orderBy('order_by ASC')->all();
        $section->setChildren($sections);
        foreach($sections as $key=>$s){
            if($s->parent_id != null){
                unset($sections[$key]);
            }
        }
        return $this->render('@wd-site-tree/views/section/index', [
            'sections' => $sections,
        ]);
    }
    public function actionAdd() {
        $csrftoken = Yii::$app->request->validateCsrfToken();
        $post = Yii::$app->request->post();

        if ($post) {
            $section = new Section();
            $section->createNew($post);
            return $this->redirect(Url::to(['/site-tree/site-tree/index','lang' => Yii::$app->language]));
        } else {
            $access = UserGroup::getGroupAccess('sitetree');
            $sections = new Section();
            $sections = $sections::find()->all();
            $section_titles = [];
            foreach($sections as $section){
                $section_titles[$section->id] = $section->name;
            }
            return $this->render('@wd-site-tree/views/section/create', [
                'sections' => $section_titles,
                'model' => new Section()
            ]);
        }
    }

    public function actionEdit($id) {
        if (Yii::$app->request->isPost) {
            $post = $this->getAllInput();
            $section = Section::createNew($post);
            if ($section->errors) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                throw new HttpException(422, json_encode($section->errors));
            }
            return json_encode(['data' => ['url' => Url::to(['/site-tree/site-tree/edit', 'lang'=>Yii::$app->language, 'id'=>$section->id])]]);
        } else {
            $model = new Section();
            $section = $model::find()->where(['id'=>$id])->one();
            $sections = $model::find()->all();
            $section_titles = [];
            foreach($sections as $s){
                $section_titles[$s->id] = $s->name;
            }
            $model->setChildren($sections);
            foreach($sections as $key=>$s){
                if($s->parent_id != null){
                    unset($sections[$key]);
                }
            }
            $setting = new Settings();

            return $this->render('@wd-site-tree/views/section/edit', [
                    'section' => $section,
                    'sections' => $sections,
                    'model' => $model,
                    'parents' => $section_titles
            ]);
        }

    }
    public function actionTreeOrderChange(){
        $post = Yii::$app->request->post();
        $section = new Section();
        $found_section = $section->find()->where(['id'=>$post['node_id']])->one();
        $section->changeOrder($found_section, $post);
        return json_encode(true);
    }

    /*
        * Koka zara dzēšana
        */
    public function actionDelete() {
        $get = Yii::$app->request->get();
            Section::deleteSection($get['id']);
            $this->redirect(Url::to(['site-tree/index', 'lang'=>Yii::$app->language]));
    }


}
