<?php

namespace wdigital\cms\siteTree\controllers;

use backend\controllers\BackendParentController;
use wdigital\cms\siteTree\models\Html_content;
use wdigital\cms\siteTree\models\Section;
use common\models\Settings;
use common\models\User;
use common\models\UserGroup;
use Yii;
use yii\helpers\Url;
use yii\web\HttpException;
use yii\web\NotFoundHttpException;
use yii\web\Response;
use function json_encode;

class HtmlController extends BackendParentController {

    public function beforeAction($action) {
        return parent::beforeAction($action);
    }
    public function actionAdd() {
        $csrftoken = Yii::$app->request->validateCsrfToken();
        $post = Yii::$app->request->post();

        if ($post) {
            $section = new Section();
            $section->createNew($post);
            return $this->redirect(Url::to(['/site-tree/site-tree/index','lang' => Yii::$app->language]));
        } else {
            $access = UserGroup::getGroupAccess('sitetree');
            $sections = new Section();
            $sections = $sections::find()->all();
            $section_titles = [];
            foreach($sections as $section){
                $section_titles[$section->id] = $section->name;
            }
            return $this->render('@wd-site-tree/views/section/create', [
                'sections' => $section_titles,
                'model' => new Section()
            ]);
        }
    }

    public function actionEdit($id) {
        $csrftoken = Yii::$app->request->validateCsrfToken();
        $post = Yii::$app->request->post();
        if ($post) {
            $html = Html_content::find()->where(['id'=>$id])->one();
            $html->scenario = Html_content::SCENARIO_UPDATE;
            $html->load($post);
            if($html->save()) {
                return $this->redirect(Url::to(['/site-tree/site-tree/index', 'lang' => Yii::$app->language, 'id' => $id]));
            }
        } else {
            $model = new Html_content();
            $html = $model->find()->where(['section_id'=>$id])->one();
            $setting = new Settings();
            return $this->render('@wd-site-tree/views/section/html/edit', [
                    'model' => $model,
                    'html' => $html
                ]
            );
        }
    }

    /*
        * Koka zara dzēšana
        */
    public function actionDelete() {
        if(!User::checkAccess('tree-options', 'delete')){
            return $this->redirect(Url::to(['admin/insufficient-permissions', 'lang'=>Yii::$app->language]));
        }
        else {
            $get = Yii::$app->request->get();
    //        if (isset($branch) && Branch::validateDeletion($get['id'], true)) {
                Section::deleteSection($get['id']);
                $this->redirect(Url::to(['/site-tree/site-tree/index', 'lang'=>Yii::$app->language]));
    //        } else $this->redirect('/admin/error');
        }
    }


}
