<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\i18n\models\Language;
use wdigital\cms\siteTree\models\Section;
use common\models\Settings;
use common\models\User;
use common\models\UserGroup;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\helpers\Url;
use yii\web\HttpException;
use yii\web\Response;
use function json_encode;

class DefaultController extends Controller {

    public function beforeAction($action) {
        return parent::beforeAction($action);
    }

    public function actionIndex() {
        $sections = Section::find()->where(['lang' => Yii::$app->language])->orderBy('order_by ASC')->all();
        Section::generateSiteTreeStructure($sections);
        return $this->render('@wd-site-tree/views/section/index', [
            'sections' => $sections,
        ]);
    }
    public function actionAdd() {
        $csrftoken = Yii::$app->request->validateCsrfToken();
        $post = Yii::$app->request->post();

        if ($post) {
            $section = new Section();
            $section->createNew($post);
            return $this->redirect(Url::to(['index']));
        } else {
            //$access = UserGroup::getGroupAccess('sitetree');
            $sections = new Section();
            $sections = $sections::find()->where(['lang'=>Yii::$app->language])->all();
            $section_titles = [];
            foreach($sections as $section){
                $section_titles[$section->id] = $section->name;
            }
            return $this->render('@wd-site-tree/views/section/create', [
                'sections' => $section_titles,
                'model' => new Section()
            ]);
        }
    }

    public function actionEdit($id) {
        $post = Yii::$app->request->post();
        if ($post) {
            $section = new Section();
            $section->editSection($post,$id);
            return $this->redirect(Url::to(['index']));
        }else {
            $model = new Section();
            $section = $model::find()->where(['id'=>$id])->one();
            $sections = $model::find()->where(['lang' => Yii::$app->language])->all();
            $section_titles = [];
            foreach($sections as $s){
                if($s->id != $section->id) {
                    $section_titles[$s->id] = $s->name;
                }
            }

            $sections = Section::find()->where(['lang' => Yii::$app->language])->orderBy('order_by ASC')->all();
            Section::generateSiteTreeStructure($sections);

            return $this->render('@wd-site-tree/views/section/edit', [
                    'section' => $section,
                    'sections' => $sections,
                    'model' => $model,
                    'parents' => $section_titles
            ]);
        }

    }
    public function actionTreeOrderChange(){

        $post = Yii::$app->request->post();
        $section = new Section();
        $found_section = $section->find()->where(['id'=>$post['node_id']])->one();
        $section->changeOrder($found_section, $post);
        //return json_encode(['success' => true ]);
    }

    /*
        * Koka zara dzēšana
        */
    public function actionDelete() {
        $get = Yii::$app->request->get();
            Section::deleteSection($get['id']);
            $this->redirect(Url::to(['index']));
    }


}
