# White Digital CMS Site Tree Module

The CMS Site Tree management module. Build Site Tree specific to WD CMS.


## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-site-tree:^1.0.0

or add

    "wdigital/cms-site-tree": "^1.0.0"

to the `require` section of your `composer.json` file.


### 2. Configure

> IMPORTANT! Ensure that your application does not have a `site-tree` component configured beforehand.

    'modules' => [
        // ...
        'site-tree' => [
            'class' => wdigital\cms\siteTree\Module::class
        ]
    ],

>Ensure that you have configutration in config/main.php

    'aliases' => [
            // ...
            '@wd-inspinia'   => '@vendor/wdigital/cms-inspinia/src',
            '@wd-site-tree'   => '@vendor/wdigital/cms-site-tree/src',
        ],
>If you have RBAC ensure that you have to extend behaviours with the controller you mapped accordignly to
your package controller.

### 3. Migrate

    $ php yii migrate/up --migrationNamespaces=wdigital\\cms\\siteTree\\migrations

[composer]: http://getcomposer.org/download/

### 4.New content type creation

If you want to create new content type dropdown, you have to add content-types in the
module config like this

     site-tree' => [
                 'class' => wdigital\cms\siteTree\Module::class,
                 'content_types' => [
                     ['value' => 'product', 'label' => 'Product section', 'category' => 'site-tree'],
                     ['value' => 'test', 'label' => 'Test section', 'category' => 'site-tree'],
                 ],
             ],
Content-types will merge with the default ones, which are: 
"HTML", "GDPR", "Redirect". For translations you'll have to 
force the translation for message command to work since it only reads
plain text from files. You can add translation in the new content type
model. Like this:

    class Product extends ActiveRecord
    {
        /**
         * {@inheritdoc}
         */
    
        public static function tableName()
        {
            return '{{%products}}';
        }
        public function attributeLabels()
        {
            return [
                'site-tree-section' => Yii::t('site-tree','Product section')
            ];
        }
    
    }

In the example you can see that I've added a translation with the same category and same label from the config example.
