<?php
namespace wdigital\cms\siteTree\models;

use common\components\FileControl;
use common\components\Image;
use common\models\ContentTypes;
use common\models\ContentTypes\Contact;
use common\models\ContentTypes\HTML;
use common\models\ContentTypes\News;
use common\models\ContentTypes\President;
use common\models\ContentTypes\SocialPost;
use common\models\ParentModel;
use Yii;
use yii\caching\TagDependency;
use yii\db\ActiveRecord;
use yii\rest\ActiveController;
use yii\web\NotFoundHttpException;
use yii\web\ServerErrorHttpException;

/**
 * @property int    $id
 * @property int    $parent_id
 * @property string $name
 * @property string $slug
 * @property string $type
 * @property bool   $active
 * @property int    $order_by
 * @property string $lang
 * @property string $redirect_to
 * @property string $image
 */
class Html_content extends ActiveRecord {

    const TABLE = '{{%html}}';
    const IMG_DIR = 'uploads/html';
    public static $tree = null;
    public $children = [];
    public $depth;
    public $path;
    public $currSection = null;
    public $prevSection = null;
    public $articleSlug = null;
    public $fullSlug;
    public $active = 0;
    public $lang = 'lv';

    const SCENARIO_SAVE = 'save';
    const SCENARIO_UPDATE = 'update';


	public function getSection()
	{
		return $this->hasOne(Section::className(), ['id' => 'section_id']);
	}


    public function rules() {
        return [
            [['section_id', 'content'], 'safe', 'on' => self::SCENARIO_SAVE],
            [['content'], 'safe', 'on' => self::SCENARIO_UPDATE],
        ];
    }
    public function createNew($section_id, $content){
	    $html = new self();
        $html->content = $content;
        $html->section_id = $section_id;
        if($html->save()){
            return true;
        }else{
            return false;
        }
    }

    public function changeOrder($section, $post){
        $model = new Section();
        $updated_section = $section;
        if($post['new_parent'] == '#'){
            $updated_section->parent_id = null;
        }else{
            $updated_section->parent_id = $post['new_parent'];
        }
        if($post['new_parent'] == '#'){
            $sections = $model->parents();
            foreach($sections as $s){
                if($s->order_by >= $post['position']){
                    $s->order_by += 1;
                    $s->save();
                }
            }
            $updated_section->order_by = $post['position'];
        }else{
            $sections = $model->find()->where(['parent_id' => $post['new_parent']])->all();
            foreach($sections as $s){
                if($s->order_by >= $post['position']){
                    $s->order_by += 1;
                    $s->save();
                }
            }
            $updated_section->order_by = $post['position'];
        }
        $updated_section->save();
    }

    public static function deleteHtml($id) {
        $content = self::findOne($id);
        if (isset($content)) {
            $content->delete();
        }
    }
}
