<?php
namespace wdigital\cms\siteTree\migrations;
use yii\db\Migration;

/**
 * Handles the creation of table `site_tree`.
 */
class m171114_124604_create_site_tree_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp() {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        //SECTIONS
        $this->createTable('section', [
            'id' => $this->primaryKey()->unsigned(),
            'parent_id' => $this->integer(11)->defaultValue(null)->unsigned(),
            'name' => $this->string()->notNull(),
            'slug' => $this->string()->notNull(),
            'type' => $this->string()->notNull(),
            'active' => $this->boolean()->notNull()->defaultValue(0),
            'order_by' => $this->integer()->notNull(),
            'lang' => $this->string()->notNull(),
            'redirect_to' => $this->string(),
            'image' => $this->string()
        ], $tableOptions);
        $this->createIndex('idx_section_parent', 'section', 'parent_id');
        $this->addForeignKey('fk_section_parent', 'section', 'parent_id', 'section', 'id', 'CASCADE');
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('section');
    }
}
