<?php
namespace wdigital\cms\siteTree\migrations;
use yii\db\Migration;

/**
 * Handles the creation of table `html`.
 */
class m171114_135056_create_html_content_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up() {
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('html_content', [
            'id' => $this->primaryKey()->unsigned(),
            'section_id' => $this->integer(11)->notNull()->unsigned(),
            'content' => $this->text(),
        ], $tableOptions);

        $this->createIndex(
                'idx_html_section', 'html_content', 'section_id'
        );

        $this->addForeignKey(
                'fk_html_section', 'html_content', 'section_id', 'section', 'id', 'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down() {
        $this->dropForeignKey(
                'fk_html_section', 'html_content'
        );

        $this->dropIndex(
                'idx_html_section', 'html_content'
        );

        $this->dropTable('html');
    }

}
