<?php

use wdigital\cms\inspinia\widgets\SiteTree;
use yii\base\DynamicModel;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('section', 'Edit section: ') . $model->name;
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a class="btn btn-primary btn-xs" href="<?= Url::to(['/site-tree/add', 'lang' => Yii::$app->language])?>">New section</a>
                </div>
            </div>
            <div class="ibox-content animated fadeInUp">
                <div hidden class="js-active-node-id" data-id="<?= $section->id?>"></div>
                <div id="jstree1">
                    <?php
                    $sitetree = new SiteTree();
                    echo $sitetree->renderTree($sections,'',true,'');
                    ?>

                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('section', 'By submitting this form, you can edit this section') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'edit-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['/section/edit', 'lang' => Yii::$app->language, 'id' => $section->id],
                            ])
                    ?>
                    <?= $form->field($section, 'parent_id')->dropDownList($parents, ['prompt' => ['text' => Yii::t('section', 'None'), 'options' => ['value' => 0]]]) ?>
                    <?=
                    $form->field($section, 'type')->dropDownList([
                        "html" => "HTML",
                        "redirect" => "Pāradresēšanas/pagaidu sadaļa",
                    ])
                    ?>
                    <?= $form->field($section, 'name')->textInput(["data-slug-field" => "edit-name"]) ?>
                    <?= $form->field($section, 'slug')->textInput(["data-slug-target" => "edit-name"]) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('form', 'Edit'), ['class' => 'btn btn-primary', 'name' => 'edit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
