<?php

namespace wdigital\cms\rbac;

use dektrium\rbac\RbacConsoleModule as BaseModule;
use Yii;
use yii\helpers\ArrayHelper;

class ConsoleModule extends BaseModule
{
    /**
     * Console application command (controller ID) for running migrations.
     * @var string
     */
    public $migrateCommand = 'migrate';

    /**
     * Location of the migrations for this module.
     * @var string
     */
    public $migrationPath = '@yii/rbac/migrations';

    /**
     * The namespace of migrations for this module.
     * @var string
     */
    public $migrationNamespace = __NAMESPACE__ . '\\migrations';

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();

        $this->injectMigrations(Yii::$app);
    }

    /**
     * Called when bootstrapping a console application with this module.
     *
     * @param ConsoleApplication $app
     */
    private function injectMigrations($app)
    {
        $migrateCommand = $this->migrateCommand;

        $migrateConfig = $this->retrieveCommandConfig($app, $migrateCommand);
        if ($migrateConfig) {
            $migrateConfig = is_string($migrateConfig)
                ? ['class' => $migrateConfig]
                : (array)$migrateConfig; // better safe than sorry

            $app->controllerMap[$migrateCommand] = $this->setSubValue($migrateConfig, 'migrationPath', $this->migrationPath, ['@app/migrations']);
            $app->controllerMap[$migrateCommand] = $this->setSubValue($app->controllerMap[$migrateCommand], 'migrationNamespaces', $this->migrationNamespace);
        }
    }

    /**
     * Returns the config of a command or false, if no such command is configured.
     *
     * @param ConsoleApplication $app
     * @param string $command
     * @return array|boolean
     */
    protected function retrieveCommandConfig($app, $command)
    {
        if (!empty($app->controllerMap[$command])) {
            return $app->controllerMap[$command];
        } else {
            $coreCommands = $app->coreCommands();
            if (isset($coreCommands[$command])) {
                return $coreCommands[$command];
            }
        }

        return false;
    }

    /**
     * Inject a sub-value into an array element of an array.
     *
     * @param array $array
     * @param string $parentPath Path to the parent element.
     * @param mixed $value
     * @param array $parentDefault Default value for the parent element.
     * @param string $key Key in the parent element to set. If null, the value will be appended to the parent.
     * @return array The modified array.
     */
    private function setSubValue($array, $parentPath, $value, $parentDefault = [], $key = null)
    {
        $parent = ArrayHelper::getValue($array, $parentPath, $parentDefault);

        if ($key !== null) {
            $parent[$key] = $value;
        } elseif (!in_array($value, $parent)) {
            $parent[] = $value;
        }

        ArrayHelper::setValue($array, $parentPath, $parent);

        return $array;
    }
}
