White Digital CMS Role Based Access Control Module
==================================================

The CMS RBAC module. Builds upon [`dektrium/yii2-rbac`] with adjustments specific to WD CMS.


Installation
------------

### 1. Download

1. Add the WD Composer repo to your `composer.json`:

        "repositories": [{
            "type": "composer",
            "url": "https://composer.wdigital.lv"
        }]

2. Since currently [`dektrium/yii2-rbac`] is still at alpha, you are, sadly, required to significantly lower the
   stability constraint for your project:

        "minimum-stability": "alpha",

    It is also recommended to add

        "prefer-stable": true,

3. Require the package by adding

        "wdigital/cms-rbac": "^0.1.0"

    to the `require` section of `composer.json` or run

        $ composer require wdigital/cms-rbac:^0.1.0

### 2. Configure

#### 2.1. Web Application Module

Add the module to your web application:

    'modules' => [
        // ...
        'rbac' => wdigital\cms\rbac\Module::class,
    ],

#### 2.1. Console Application Module

Add the module to your console application:

    'modules' => [
        // ...
        'rbac' => wdigital\cms\rbac\ConsoleModule::class,
    ],

Bootstrap the module to inject migrations:

    'bootstrap' => [
        // ...
        'rbac',
    ],


### 3. Migrate

    $ php yii migrate


[`dektrium/yii2-rbac`]: https://github.com/dektrium/yii2-rbac
