<?php

namespace wdigital\cms\rbac;

use dektrium\rbac\RbacWebModule as BaseModule;
use wdigital\cms\rbac\models\Permission;
use wdigital\cms\rbac\models\Role;
use wdigital\cms\rbac\models\Rule;
use wdigital\inheritingMessageSource\InheritingMessageSourceInterface;
use wdigital\inheritingMessageSource\PhpMessageSource as InheritingPhpMessageSource;
use Yii;
use yii\helpers\StringHelper;
use yii\i18n\PhpMessageSource;

class Module extends BaseModule
{
    /**
     * @inheritdoc
     */
    public $controllerNamespace = 'dektrium\\rbac\\controllers';

    /**
     * @var array
     */
    public $modelMap = [];

    /**
     * Points to the parent module views.
     * @var string
     */
    protected $defaultViewPath = '@vendor/dektrium/yii2-rbac/views';

    /**
     * Models overriding the default model map ones.
     * @var array
     */
    protected $overrideModels = [
        Permission::class,
        Rule::class,
        Role::class,
    ];

    /**
     * @inheritdoc
     */
    public function __construct($id, $parent = null, $config = [])
    {
        if (empty($config['viewPath'])) {
            $config['viewPath'] = $this->defaultViewPath;
        }

        parent::__construct($id, $parent, $config);
    }

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();

        $app = Yii::$app;
        $this->injectTranslations($app);
        $this->overrideViews($app);
        $this->overrideModels();
    }

    /**
     *
     */
    private function overrideModels()
    {
        $modelMap = array_merge($this->overrideModels, $this->modelMap);
        foreach ($modelMap as $name => $definition) {
            $modelName = is_array($definition)
                ? $definition['class']
                : $definition;
            if (is_integer($name)) {
                $name = StringHelper::basename($modelName);
            }
            Yii::$container->set('dektrium\\rbac\\models\\' . $name, $definition);

            $this->modelMap[$name] = $modelName;
        }
    }

    /**
     * @param WebApplication $app
     */
    private function overrideViews($app)
    {
        if (empty($app->view->theme)) {
            $app->view->theme = Yii::createObject(['class' => 'yii\base\Theme']);
        }
        $app->view->theme->pathMap[$this->defaultViewPath] = '@vendor/wdigital/cms-rbac/src/views';
    }

    /**
     * @param WebApplication|ConsoleApplication $app
     */
    protected function injectTranslations($app)
    {
        $messageSources = &$app->i18n->translations;

        if (empty($messageSources['rbac*'])) {
            $parentSource = [
                'class' => PhpMessageSource::class,
                'basePath' => '@vendor/dektrium/yii2-rbac/messages',
                'sourceLanguage' => 'en-US',
            ];
        } else {
            $parentSource = $messageSources['rbac*'];
            if (is_array($parentSource) || is_string($parentSource)) {
                $parentSource = $messageSources['rbac*'] = Yii::createObject($parentSource);
            }
        }

        if (!$parentSource instanceof InheritingMessageSourceInterface) {
            $messageSources['rbac*'] = [
                'class' => InheritingPhpMessageSource::class,
                'basePath' => __DIR__ . '/messages',
                'sourceLanguage' => 'en',
                'parentSources' => [$parentSource],
            ];
        }
    }

}
