<?php
/**
 * This is the template for generating the model class of a specified table.
 */

/* @var $this yii\web\View */
/* @var $generator yii\gii\generators\model\Generator */
/* @var $tableName string full table name */
/* @var $className string class name */
/* @var $queryClassName string query class name */
/* @var $tableSchema yii\db\TableSchema */
/* @var $properties array list of properties (property => [type, name. comment]) */
/* @var $labels string[] list of attribute labels (name => label) */
/* @var $rules string[] list of validation rules */
/* @var $relations array list of relations (name => relation declaration) */

echo "<?php\n";
?>

namespace <?= $generator->ns ?>;

use Yii;
<?php if ($generator->enableI18New): ?>
use wdigital\cms\i18new\components\ActiveRecordHelper;
use wdigital\cms\i18new\models\Language;
use yii2tech\ar\variation\VariationBehavior;
<?php endif; ?>
/**
 * This is the model class for table "<?= $generator->generateTableName($tableName) ?>".
 *
<?php foreach ($properties as $property => $data): ?>
 * @property <?= "{$data['type']} \${$property}"  . ($data['comment'] ? ' ' . strtr($data['comment'], ["\n" => ' ']) : '') . "\n" ?>
<?php endforeach; ?>
<?php if (!empty($relations)): ?>
 *
<?php foreach ($relations as $name => $relation): ?>
 * @property <?= $relation[1] . ($relation[2] ? '[]' : '') . ' $' . lcfirst($name) . "\n" ?>
<?php endforeach; ?>
<?php endif; ?>
 */
class <?= $className ?> extends <?= '\\' . ltrim($generator->baseClass, '\\') . "\n" ?>
{
<?php if ($generator->enableI18New): ?>

    /**
    * @return string
    */
    public static function primaryField() :string
    {
        return '<?= $generator->primaryField; ?>';
    }

    /**
    * @return array
    */
    public function behaviors() :array
    {
        return [
            'translations' => [
                'class' => VariationBehavior::class,
                'variationsRelation' => '<?= $generator->generateTableName($tableName).'Translations' ?>',
                'defaultVariationRelation' => 'defaultTranslation',
                'variationOptionReferenceAttribute' => 'language_id',
                'optionModelClass' => Language::class,
                'defaultVariationOptionReference' => Language::getIdFromCode(Yii::$app->language),
                'variationSaveFilter' => [ActiveRecordHelper::class, 'filterVariationSave'],
            ],
        ];
    }
<?php endif; ?>
    /**
     * @inheritdoc
     */
    public static function tableName() :string
    {
        return '<?= $generator->generateTableName($tableName) ?>';
    }
<?php if ($generator->db !== 'db'): ?>

    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('<?= $generator->db ?>');
    }
<?php endif; ?>

    /**
     * @inheritdoc
     */
    public function rules() :array
    {
        return [<?= empty($rules) ? '' : ("\n            " . implode(",\n            ", $rules) . ",\n        ") ?>];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() :array
    {
        return [
<?php foreach ($labels as $name => $label): ?>
            <?= "'$name' => " . $generator->generateString($label) . ",\n" ?>
<?php endforeach; ?>
        ];
    }
<?php foreach ($relations as $name => $relation): ?>

    /**
     * @return \yii\db\ActiveQuery
     */
    public function get<?= $name ?>()
    {
        <?= $relation[0] . "\n" ?>
    }
<?php endforeach; ?>
<?php if ($queryClassName): ?>
<?php
    $queryClassFullName = ($generator->ns === $generator->queryNs) ? $queryClassName : '\\' . $generator->queryNs . '\\' . $queryClassName;
    echo "\n";
?>
    /**
     * @inheritdoc
     * @return <?= $queryClassFullName ?> the active query used by this AR class.
     */
    public static function find()
    {
        return new <?= $queryClassFullName ?>(get_called_class());
    }
<?php endif; ?>

<?php if ($generator->enableI18New): ?>
    /**
    * @return \yii\db\ActiveQuery
    */
    public function getDefaultTranslation()
    {
        return $this->hasDefaultVariationRelation();
    }

    /**
    * @param array $data
    * @param null $formName
    * @return bool
    */
    public function load($data, $formName = null): bool
    {
        $translationModels = ArrayHelper::map(
            $this->getVariationModels(),
            'language_id',
            function ($translatedModel) {
                return $translatedModel;
            }
        );
        return parent::load($data, $formName) && Model::loadMultiple($translationModels, $data)  && $this->setVariationModels($translationModels);
    }

<?php endif; ?>
}
