function instantiateCroppers(elem) {
    var aspectRatio = $(elem).attr('data-aspect-ratio');
    var attribute = $(elem).attr('data-attribute');
    var uploadedImg = $(elem).siblings('.btn-group').first().find('.js-input-image').first();
    var img = $(elem).find('img');
    if (typeof aspectRatio !== 'undefined') {
        var heightAndWidth = aspectRatio.split(':'),
            ratio = heightAndWidth[0] / heightAndWidth[1];
    }
    img.cropper({
        aspectRatio: ratio,
        zoomable: false,
        zoomOnTouch: false,
        zoomOnWheel: false,
        autoCropArea: 1,
        done: function (data) {
            $(elem).siblings('.btn-group').first().find('input[name="coords['+attribute+'][x]"]').val(data.x);
            $(elem).siblings('.btn-group').first().find('input[name="coords['+attribute+'][y]"]').val(data.y);
            $(elem).siblings('.btn-group').first().find('input[name="coords['+attribute+'][w]"]').val(data.width);
            $(elem).siblings('.btn-group').first().find('input[name="coords['+attribute+'][h]"]').val(data.height);
        }
    });
    if (window.FileReader) {
        uploadedImg.on('change', function () {
            var fileReader = new FileReader(),
                files      = this.files,
                file       = files[0];
            if (file) {
                if (/^image\/\w+$/.test(file.type)) {
                    fileReader.readAsDataURL(file);
                    fileReader.onload = function () {
                        img.cropper("replace", this.result);

                    };
                } else {
                    toastr['warning']("Please choose an image file.", "Warning");
                }
            }
        });
    } else {
        uploadedImg.addClass("hide");
    }
}

$(document).ready(function(){

    $().cropper("destroy");

    var containers = $('.ibox-content').find('.js-img-crop-container');

    containers.each(function (idx, elem) {
        instantiateCroppers(elem);
    });
});