<?php

use yii\helpers\Inflector;
use yii\helpers\StringHelper;

/* @var $this yii\web\View */
/* @var $generator yii\gii\generators\crud\Generator */

/* @var $model \yii\db\ActiveRecord */
$model = new $generator->modelClass();
$safeAttributes = $model->safeAttributes();
if (empty($safeAttributes)) {
    $safeAttributes = $model->attributes();
}

echo "<?php\n";
?>

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model <?= ltrim($generator->modelClass, '\\') ?> */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="<?= Inflector::camel2id(StringHelper::basename($generator->modelClass)) ?>-form">

    <?= "<?php " ?>$form = ActiveForm::begin(['enableClientValidation' => false]); ?>

    <?php if ($generator->enableI18New && $generator->translatableFields): ?>
    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
        <?= "<?php " ?>foreach (Yii::$app->params['languages'] as $language): ?>
            <li <?= "<?php "?>if (Yii::$app->language === $language['code']): ?> class="active" <?= "<?php " ?>endif ?> ><a
                        href="#new-<?= "<?= " ?> $language['code'] ?>"
                        data-toggle="tab"><?= "<?= " ?> Html::encode($language['name']); ?></a></li>
        <?= "<?php " ?>endforeach; ?>
    </ul>
    <div class="tab-content">
        <?= "<?php " ?>foreach (Yii::$app->params['languages'] as $language): ?>
        <div class="tab-pane fade in <?= "<?php " ?>if (Yii::$app->language === $language['code']): ?> active <?= "<?php " ?>endif; ?>"
             id="new-<?= "<?= " ?>$language['code'] ?>">

            <?= "<?php " ?>$translatedModel = $model->getVariationModel($language['id']); ?>

            <?php foreach ($generator->getTranslatedColumnNames() as $attribute): ?>
               <? if (in_array($attribute, $generator->translatableFields) && $attribute != 'image') :?>
                    <?= "    <?= " . $generator->generateTranslatableActiveField($attribute, $model) . " ?>\n\n"; ?>
               <?php endif; ?>
            <?php endforeach; ?>
        </div>
            <?= "<?php " ?>endforeach; ?>
    <?php endif; ?>

<?php foreach ($generator->getColumnNames() as $attribute) {
    if (in_array($attribute, $generator->translatableFields) && $attribute != 'image'){
        continue;
    }
    elseif (in_array($attribute, $safeAttributes) && $attribute != 'image') {
        echo "    <?= " . $generator->generateActiveField($attribute) . " ?>\n\n";
    } elseif (in_array($attribute, $safeAttributes) && $attribute == 'image'){
        echo $generator->generateActiveField($attribute) . "\n\n";
    }
} ?>
    <div class="form-group">
        <?= "<?= " ?>Html::submitButton($model->isNewRecord ? <?= $generator->generateString('Create') ?> : <?= $generator->generateString('Update') ?>, ['class' => 'btn btn-primary']) ?>
    </div>

    <?= "<?php " ?>ActiveForm::end(); ?>
    <?php if ($generator->enableI18N && $generator->translatableFields): ?>
        </div>
    <?php endif; ?>
</div>
