<?php

use yii\helpers\Html;

if ($aspectRatio) {
    echo Html::beginTag(
        'div',
        [
            'class' => 'js-img-crop-container',
            'data-aspect-ratio' => $aspectRatio,
            'data-attribute' => $attribute
        ]
    );
} else {
    echo Html::beginTag(
        'div',
        [
            'class' => 'js-img-crop-container',
            'data-attribute' => $attribute
        ]
    );
}


echo Html::img(
    $src,
    [
        'alt' => $alt,
        'data-backup-src' => $backupSrc,
    ]
);

echo Html::endTag('div');

echo Html::beginTag(
    'div',
    [
        'class' => 'btn-group',
    ]
);

$buttonInput = Html::activeFileInput(
    $model,
    $attribute,
    [
        'class' => 'hide js-input-image',
        'accept' => 'image/*',
        'hiddenOptions' =>
            ['value' => null],
    ]
);
$buttonInput .= $buttonText;

echo Html::label(
    $buttonInput,
    Html::getInputId($model, $attribute),
    [
        'title' => $buttonText,
        'class' => 'btn btn-primary btn-sm',
    ]
);

foreach ($coords as $coord) {
    echo Html::hiddenInput("coords[{$attribute}][{$coord}]", '0');
}

echo Html::endTag('div');

