<?php
namespace wdigital\cms\inspinia\widgets;

use wdigital\cms\inspinia\assets\ImageCropperAsset;
use yii\widgets\InputWidget;

/**
 * ImageCropper widget
 */
class ImageCropperWidget extends InputWidget
{
    public $src;
    public $backupSrc = '';
    public $alt = '';
    public $errorField;
    public $buttonText;
    public $aspectRatio;
    private const COORDS = ['x', 'y', 'w', 'h'];

    public function init()
    {
        $this->buttonText = $this->buttonText ?: \Yii::t('inspinia', 'Upload image file');
        parent::init();
    }


    public function run() {
        $this->registerWidgetAssets();
        return $this->render('imageCropper', [
            'id' => $this->getId(),
            'model' => $this->model,
            'attribute' => $this->attribute,
            'name' => $this->name,
            'src' => $this->src,
            'backupSrc' => $this->backupSrc,
            'alt' => $this->alt,
            'buttonText' => $this->buttonText,
            'aspectRatio' => $this->aspectRatio,
            'coords' => self::COORDS
        ]);
    }

    /**
     * Registers ImageCropper assets
     * @codeCoverageIgnore
     */
    protected function registerWidgetAssets(): void
    {
        $view = $this->getView();
        ImageCropperAsset::register($view);
    }
}
