<?php
    /**
     * This is the template for generating the translated model class of a specified table.
     */

    /* @var $this yii\web\View */
    /* @var $generator yii\gii\generators\model\Generator */
    /* @var $tableName string full table name */
    /* @var $className string class name */
    /* @var $queryClassName string query class name */
    /* @var $tableSchema yii\db\TableSchema */
    /* @var $properties array list of properties (property => [type, name. comment]) */
    /* @var $labels string[] list of attribute labels (name => label) */
    /* @var $rules string[] list of validation rules */
    /* @var $relations array list of relations (name => relation declaration) */

    echo "<?php\n";
?>

namespace <?= $generator->ns ?>;

use Yii;
use yii\db\ActiveRecord;
<?php if ($generator->enableI18N): ?>
use wdigital\cms\i18new\models\Language;
<?php endif; ?>
/**
* This is the model class for table "<?= $generator->generateTableName($tableName) . '_translation' ?>".
*
<?php foreach ($translatedProperties as $property => $data): ?>
* @property <?= "{$data['type']} \${$property}"  . ($data['comment'] ? ' ' . strtr($data['comment'], ["\n" => ' ']) : '') . "\n" ?>
<?php endforeach; ?>
*/
class <?= $translatedModelClassName ?> extends <?= '\\' . ltrim($generator->baseClass, '\\') . "\n" ?>
{
    /**
    * @inheritdoc
    */
    public static function tableName()
    {
        return '<?= $generator->generateTableName($tableName) . '_translation' ?>';
    }

    /**
    * @inheritdoc
    */
    public function rules()
    {
        return [<?= empty($translatedRules) ? '' : ("\n            " . implode(",\n            ", $translatedRules) . ",\n        ") ?>];
    }

    /**
    * @inheritdoc
    */
    public function attributeLabels()
    {
        return [
        <?php foreach ($translatedLabels as $name => $label): ?>
            <?= "'$name' => " . $generator->generateString($label) . ",\n" ?>
        <?php endforeach; ?>
        ];
    }
}