White Digital Yii2 Module Composer Package Project Template
===========================================================

A project template for a Yii2 module package.

* * *

# Configuration
## Configure gii module, to use custom INSPINIA generator
        $config['modules']['gii'] = [
            'class' => 'yii\gii\Module',
            'allowedIPs' => ['*'], // access gii module from all ip adresses (change if necessary)
            'generators' => [ //here
                'crud' => [ // generator name
                    'class' => 'wdigital\cms\inspinia\generators\crud\Generator', // generator class
                    'templates' => [ //setting for out templates
                        'inspinia' => '@vendor/wdigital/cms-inspinia/src/generators/crud/inspinia', // template name => path to template
                    ]
                ]
            ],
        ];
## Configure view and formatter component for app, to use inspinia view templates and proper date format
        'view' => [
            'theme' => [
                'basePath' => '@vendor/wdigital/cms-inspinia',
                'baseUrl' => '@vendor/wdigital/cms-inspinia',
                'pathMap' => [
                    '@app/views' => '@vendor/wdigital/cms-inspinia/src/views',
                ],
            ],
        ],
        'formatter' => [
            'dateFormat' => 'php:d.m.Y',
            'nullDisplay' => '',
        ],
## For sidebar to work you have to add a menu variable in params as so
        'menu' => [
                        [
                            'label' => 'WD Admin Panel',
                            'url' => Url::to('/'),
                            'options' => [
                                    'class' => 'nav-header h3'
                            ],
                        ],
                        [
                            'label' => Yii::t('general', 'Dashboard'),
                            'url'  => Url::to('/'),
                            'icon'  => 'fa fa-th-large',
                            'options' =>
                                [
                                    'class' => 'active',
                                ]
                        ],
                        [
                            'label' => Yii::t('general', 'Site tree'),
                            'url'  => Url::to('/site-tree/default/index'),
                            'icon' => 'fa fa-sitemap',
                            'options' =>
                                [
                                    'class' => '',
                                ]
                        ],
                        [
                            'label' => Yii::t('general', 'Languages and translations'),
                            'url'  => Url::to('/language/default/index'),
                            'icon' => 'fa fa-language',
                            'options' =>
                                [
                                    'class' => '',
                                ]
                        ],
                        [
                            'label' => Yii::t('general', 'Users and User Groups'),
                            'url'  => Url::to('/user/admin/index'),
                            'icon' => 'fa fa-users',
                            'options' =>
                                [
                                    'class' => '',
                                ]
                        ],
                ],
## Site tree new content type link generation
Site Tree redactor links for new content types are generated using the content type names in links, 
for example if you create a new content type called *news* when you are going to click on the site tree
section itself you will be redirected to a link:

                /content-type/index?id=section-id
                
and therefore you will have to have a controller in your *app/views/controller*
folder named after the content-type or 
you will have to pathmap it.