<?php

use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$model = new yii\base\DynamicModel(['name', 'slug', 'type', 'parent_id']);
$this->title = Yii::t('section', 'Create new section');
$this->params['breadcrumbs'][] = $this->title;
$parents = ['0' => 'Pirmā sadaļa', '1' => 'Otrā sadaļa'];
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Html::encode($this->title) ?></h5>
                    <small class="pull-right"><?= Yii::t('section', 'By submitting this form, you can create new section') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'create-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['section/create', 'lang' => Yii::$app->language],
                            ])
                    ?>
                    <?= $form->field($model, 'parent_id')->dropDownList($parents, ['prompt' => ['text' => Yii::t('secion', 'None'), 'options' => ['value' => 0]]]) ?>
                    <?=
                    $form->field($model, 'type')->dropDownList([
                        'calendar' => 'Kalendārs',
                        'contacts' => 'Kontakti',
                        "html" => "HTML",
                        "news" => "Ziņu sadaļa",
                        "redirect" => "Pāradresēšanas/pagaidu sadaļa",
                        "gallery" => "Galeriju sadaļa",
                        "site-map" => "Lapas kartes sadaļa"
                    ])
                    ?>
                    <?= $form->field($model, 'name')->textInput(['class' => 'form-control js-slug-field', "data-slug-field" => "new-name"]) ?>
                    <?= $form->field($model, 'slug')->textInput(["data-slug-target" => "new-name"]) ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('section', 'Create'), ['class' => 'btn btn-primary', 'name' => 'submit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
