<?php

use common\models\User;
use common\models\UserGroup;
use yii\data\ActiveDataProvider;
use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;



$dataProvider = new ActiveDataProvider([
    'query' => User::find()->with('userGroup'),
    'sort' => false,
    'pagination' => [
        'pageSize' => 20,
    ],
]);
$dataProvider2 = new ActiveDataProvider([
    'query' => UserGroup::find(),
    'sort' => false,
    'pagination' => [
        'pageSize' => 20,
    ],
]);

/* @var $this View */
$this->title = Yii::t('user', 'Users and user groups');
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <!--User Groups-->
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Yii::t('user', 'User Groups') ?></h5>
                    <div class="ibox-tools">
                        <?= Html::a(Yii::t('user', 'Create new user group'),
                            Url::to(['user-group/create', 'lang' => Yii::$app->language]),
                            ['class' => 'btn btn-primary btn-xs']) ?>
                    </div>
                </div>
                <div class="ibox-content">
                    <?=
                    GridView::widget([
                        'dataProvider' => $dataProvider2,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            "name:text:" . Yii::t('user', 'Group name'),
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'header' => Yii::t('user', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                'user-group/edit',
                                                'lang' => Yii::$app->language,
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                'user-group/delete',
                                                'lang' => Yii::$app->language,
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => Yii::t('user', 'Delete user group'),
                                            'data-text' => Yii::t('user', 'Are you sure, you want to delete user group'. $model->name.'?'),
                                            'data-cancel' => Yii::t('modal', 'Cancel'),
                                            'data-ok' => Yii::t('modal', 'Ok'),
                                        ]);
                                    },
                                ],
                            ]
                        ],
                        'tableOptions' => ['class' => 'table table-striped'],
                        'summary' => ''
                    ]);
                    ?>
                </div>
            </div>
        </div>
    </div>
<!--Users-->
    <div class="row">
        <div class="col-xs-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h5><?= Yii::t('user', 'Users') ?></h5>
                    <div class="ibox-tools">
                        <?= Html::a(Yii::t('user', 'Create new user'),
                            Url::to(['user/create', 'lang' => Yii::$app->language]),
                            ['class' => 'btn btn-primary btn-xs']) ?>
                    </div>
                </div>
                <div class="ibox-content">
                    <?=
                    GridView::widget([
                        'dataProvider' => $dataProvider,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],
                            "firstname:text:" . Yii::t('user', 'Firstname'),
                            "lastname:text:" . Yii::t('user', 'Lastname'),
                            "email:email:" . Yii::t('user', 'Email'),
                            'userGroup.name:text:' . Yii::t('user', 'User Group Name'),
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'header' => Yii::t('user', 'Actions'),
                                'template' => '{update} {delete}',
                                'buttons' => [
                                    'update' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-pencil"></i>',
                                            Url::to([
                                                'user/edit',
                                                'lang' => Yii::$app->language,
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="fa fa-trash"></i>',
                                            Url::to([
                                                'user/delete',
                                                'lang' => Yii::$app->language,
                                                'id' => $model->id
                                        ]), ['class' => 'btn btn-danger btn-xs sweetalert-warning',
                                            'data-title' => Yii::t('user', 'Delete user'),
                                            'data-text' => Yii::t('user', 'Are you sure, you want to delete user '. $model->firstname.' '.$model->lastname.'?'),
                                            'data-cancel' => Yii::t('modal', 'Cancel'),
                                            'data-ok' => Yii::t('modal', 'Ok'),
                                        ]);
                                    },
                                ],
                            ]
                        ],
                        'tableOptions' => ['class' => 'table table-striped'],
                        'summary' => ''
                    ]);
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
