/**
 * @license Copyright (c) 2003-2015, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
    config.toolbarGroups = [
        { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
        { name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
        { name: 'forms', groups: [ 'forms' ] },
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
        { name: 'links', groups: [ 'links' ] },
        { name: 'insert', groups: [ 'insert' ] },
        { name: 'styles', groups: [ 'styles' ] },
        { name: 'colors', groups: [ 'colors' ] },
        { name: 'tools', groups: [ 'tools' ] },
        { name: 'others', groups: [ 'others' ] },
        { name: 'about', groups: [ 'about' ] }
    ];


    config.removeButtons = 'Save,' +
        'NewPage,' +
        'Preview,' +
        'Print,' +
        'Templates,' +
        // 'Undo,' +
        'Redo,' +
        'Find,' +
        'Replace,' +
        'SelectAll,' +
        'Scayt,' +
        'Form,' +
        'Anchor,' +
        'Checkbox,' +
        'Radio,' +
        'TextField,' +
        'Textarea,' +
        'Select,' +
        'Button,' +
        'ImageButton,' +
        'HiddenField,' +
        'Strike,' +
        //'Subscript,' +
        //'Superscript,' +
        'CreateDiv,' +
        'BidiLtr,' +
        'BidiRtl,' +
        'Language,' +
        'Flash,' +
        //'HorizontalRule,' +
        'Smiley,' +
        'SpecialChar,' +
        'PageBreak,' +
        //'Styles,' +
        'Font,' +
        'BGColor,' +
        'FontSize,' +
        'ShowBlocks,' +
        //'Image,' +
        'About';


    config.allowedContent = true;
    config.extraAllowedContent = 'img[src,alt,width,height];script[src,type,charset,language];h3[class];span[class];figure[*];iframe';

    //config.toolbar = ['VideoDetector'];


    config.filebrowserBrowseUrl = '/kcfinder/browse.php?opener=ckeditor&type=files';
    config.filebrowserImageBrowseUrl = '/kcfinder/browse.php?opener=ckeditor&type=images';
    //config.filebrowserFlashBrowseUrl = '/kcfinder/browse.php?opener=ckeditor&type=flash';
    config.filebrowserUploadUrl = '/kcfinder/upload.php?opener=ckeditor&type=files';
    config.filebrowserImageUploadUrl = '/kcfinder/upload.php?opener=ckeditor&type=images';

    //removed ck-info, ck-simple-box, ck-contact-form
//    config.extraPlugins = 'image2,justify,iframe,fakeobjects,ck-gallery,videoembed,uploadimage,uploadwidget,notificationaggregator,filetools,notification';
    config.extraPlugins = 'image2,justify,iframe,fakeobjects,videoembed';
    config.div_wrapTable = true;
    config.format_tags = "p;h1;h2;h3;div";
    config.stylesSet = 'my_styles';
};
