<?php

use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$model = new yii\base\DynamicModel(['username', 'firstname', 'lastname', 'email', 'user_group_id', 'password', 'password_repeat']);
$this->title = Yii::t('inspinia', 'Create new user');
$this->params['breadcrumbs'][] = $this->title;
$parents = ['1' => 'Pirmā grupa', '2' => 'Otrā grupa'];
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('inspinia', 'By submitting this form, you can create new user') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'create-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['user/create', 'lang' => Yii::$app->language],
                            ])
                    ?>
                    <?= $form->field($model, 'firstname')->textInput() ?>
                    <?= $form->field($model, 'lastname')->textInput() ?>
                    <?= $form->field($model, 'email')->input('email') ?>
                    <?= $form->field($model, 'user_group_id')->dropDownList($parents) ?>
                    <?= $form->field($model, 'password')->passwordInput() ?>
                    <?= $form->field($model, 'password_repeat')->passwordInput() ?>

                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('inspinia', 'Create'), ['class' => 'btn btn-primary', 'name' => 'submit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
